## Examples

In this folder are some examples of *lifelines* usage, some with and some without comments and context.

- `Cox residuals`: A notebook displaying how to create residuals for the Cox model.
- `Custom Regression Models`: A notebook with examples on how to create a custom parametric regression model.
- `Customer Churn`: A notebook analyzing customer subscription churn from a TelCom.
- [`Mixture of Exponentials and Binning`](https://nbviewer.jupyter.org/github/CamDavidsonPilon/lifelines/blob/master/examples/Mixture%20of%20Exponentials%20and%20Binning.ipynb): A notebook on dealing with binning (like from an instrument or rounding) and a mixture of distributions.
- `Modelling time-lagged conversion rates`: A notebook on custom univariate models that have a fraction of subjects that never experience the event of interest. Also known as cure models.
- `Piecewise Exponential Models and Creating Custom Models`: A notebook demonstrating how to create custom univariate models. Lots of examples.
- `Proportional hazard assumption`: A notebook for diagnosing and fixing violations of the proportional hazard assumption.
- [`SaaS churn and piecewise regression models`](https://nbviewer.jupyter.org/github/CamDavidsonPilon/lifelines/blob/master/examples/SaaS%20churn%20and%20piecewise%20regression%20models.ipynb): A notebook that demonstrates how to use the `PiecewiseExponentialRegressionFitter` for understanding SaaS customer churn.
- [`US Presidential Cabinet survival`](https://nbviewer.jupyter.org/github/CamDavidsonPilon/lifelines/blob/master/examples/US%20Presidential%20Cabinet%20survival.ipynb): Analyzing tenure in presidential cabinets over the different generations.
- `aalen_and_cook_simulation`: A demonstration of how the Cox model fails when missing independent risk factors.
- `cure_mode`l: A custom regression model of a cure model.
- `haft_model`: An implementation of a heterogeneous-AFT model. Subjects' variance can vary with their factors.
- `left_censoring_experiments`: Comparing some parametric univariate models on left-censoring data.
- `royston_parmer_splines`: an implementation of the Royston and Parmar spline survival model.



#### Other examples

 - [nice tutorial to lifelines and survival analysis](https://github.com/chrisluedtke/data-science-journal/blob/master/07-Advanced-Regression/02_Survival_Analysis.ipynb)
 - [Example of likelihood derivation of a discrete competing risks example](https://stats.stackexchange.com/questions/417303/what-is-the-likelihood-for-this-process/425052#425052)
