%% Load simulations results.
DataSet(1).DirName = 'g=30'; n = 2;
DataSet(n).DirName = 'g=35'; n = n+1;
DataSet(n).DirName = 'g=40'; n = n+1;
DataSet(n).DirName = 'g=45'; n = n+1;
DataSet(n).DirName = 'g=50'; n = n+1;
DataSet(n).DirName = 'g=50bis'; n = n+1;
DataSet(n).DirName = 'g=55'; n = n+1;
DataSet(n).DirName = 'g=55bis'; n = n+1;
DataSet(n).DirName = 'g=60'; n = n+1;
DataSet(n).DirName = 'g=60bis'; n = n+1;
DataSet(n).DirName = 'g=65';

DataMat = [];
n = 0;
for nd = 1:numel(DataSet)
   load([DataSet(nd).DirName '\StatSummary.mat']);
   for nr = 1:size(StatSummary,1)
      for nc = 1:numel(NuExt)
         n = n + 1;
         DataMat(n,1) = StatSummary(nr,nc).DownMean;
         DataMat(n,2) = StatSummary(nr,nc).UpMean;
         DataMat(n,3) = NuExt(nc);
         DataMat(n,4) = Ga;
      end
   end
end
ndx = find(~isnan(DataMat(:,1)) & ~isnan(DataMat(:,2)));
DataMat = DataMat(ndx,:);
NuExt = unique(DataMat(:,3));
Ga = unique(DataMat(:,4));


%% Load statistics on experimental data.
load('StatSummary_Exp.mat','Sleep','Light','Deep')


%% Plot NuExt fitting surface and data.
DurationRange = [0.1 2];

CM = hot(3*numel(NuExt)-1);
CM = CM(2:3:end,:);

ZRange = NuExt([1 end])' + [-1 1]*diff(NuExt(1:2))/2;

figure
hold('on')

% Smoothing NuExt surface.
% p = 0.3;
p = [];
[stNuExt,p] = tpaps(log10(DataMat(:,1:2)'),DataMat(:,3)',p);

GridSize = 20;
lDGrid = linspace(log10(DurationRange(1)),log10(DurationRange(2)),GridSize);
lUGrid = linspace(log10(DurationRange(1)),log10(DurationRange(2)),GridSize);
[lUG,lDG] = ndgrid(lUGrid,lDGrid);
GaSurf = reshape(fnval(stNuExt,[lDG(:)';lUG(:)']), size(lDG));
% contourf(10.^lDGrid,10.^lUGrid,GaSurf,NuExt)
contour(10.^lDGrid,10.^lUGrid,GaSurf,NuExt)

for ns = 1:numel(NuExt)
   ndx = find(NuExt(ns) == DataMat(:,3));
   plot(DataMat(ndx,1),DataMat(ndx,2),'ko','MarkerFaceColor',CM(ns,:));
end

plot(DurationRange,DurationRange,'k--')

plot(Deep.DownDurMean+[-1 1]*Deep.DownDurStd, [1 1]*Deep.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Deep.DownDurMean,Deep.UpDurMean+[-1 1]*Deep.UpDurStd,'k-','LineWidth',1.)
plot(Deep.DownDurMean,Deep.UpDurMean,'kd','MarkerFaceColor','b','LineWidth',1.);
plot(Light.DownDurMean+[-1 1]*Light.DownDurStd, [1 1]*Light.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Light.DownDurMean,Light.UpDurMean+[-1 1]*Light.UpDurStd,'k-','LineWidth',1.)
plot(Light.DownDurMean,Light.UpDurMean,'kd','MarkerFaceColor','r','LineWidth',1.);
plot(Sleep.DownDurMean+[-1 1]*Sleep.DownDurStd, [1 1]*Sleep.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Sleep.DownDurMean,Sleep.UpDurMean+[-1 1]*Sleep.UpDurStd,'k-','LineWidth',1.)
plot(Sleep.DownDurMean,Sleep.UpDurMean,'kd','MarkerFaceColor','g','LineWidth',1.);

grid('on')
xlabel('Down duration [s]')
ylabel('Up duration [s]')
title('\nu_{ext} [Hz]')

colormap(CM)
hcb = colorbar();
set(hcb,'YLim',ZRange)
caxis(ZRange)

set(gca,'XLim',DurationRange,'YLim',DurationRange);
set(gca,'XScale','log','YScale','log','DataAspectRatio',[1 1 1]);
set(gca,'TickDir','out','Box','on','Layer','top')

FigSize = [5 4];
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 FigSize],'PaperSize',FigSize);
print('-dpdf','NuExtVsUpDownDurations');


%% Plot Ga fitting surface and data.
DurationRange = [0.1 2];

CM = flipud(cool(3*numel(Ga)-1));
CM = CM(2:3:end,:);

ZRange = Ga([1 end])' + [-1 1]*diff(Ga(1:2))/2;

figure
hold('on')

% Smoothing Ga surface.
% p = 0.1;
p = [];
[stGa,p] = tpaps(log10(DataMat(:,1:2)'),DataMat(:,4)',p);

GridSize = 20;
lDGrid = linspace(log10(DurationRange(1)),log10(DurationRange(2)),GridSize);
lUGrid = linspace(log10(DurationRange(1)),log10(DurationRange(2)),GridSize);
[lUG,lDG] = ndgrid(lUGrid,lDGrid);
GaSurf = reshape(fnval(stGa,[lDG(:)';lUG(:)']), size(lDG));
% contourf(10.^lDGrid,10.^lUGrid,GaSurf,Ga)
contour(10.^lDGrid,10.^lUGrid,GaSurf,Ga)

for ns = 1:numel(Ga)
   ndx = find(Ga(ns) == DataMat(:,4));
   plot(DataMat(ndx,1),DataMat(ndx,2),'ko','MarkerFaceColor',CM(ns,:));
end

plot(DurationRange,DurationRange,'k--')

plot(Deep.DownDurMean+[-1 1]*Deep.DownDurStd, [1 1]*Deep.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Deep.DownDurMean,Deep.UpDurMean+[-1 1]*Deep.UpDurStd,'k-','LineWidth',1.)
plot(Deep.DownDurMean,Deep.UpDurMean,'kd','MarkerFaceColor','b','LineWidth',1.);
plot(Light.DownDurMean+[-1 1]*Light.DownDurStd, [1 1]*Light.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Light.DownDurMean,Light.UpDurMean+[-1 1]*Light.UpDurStd,'k-','LineWidth',1.)
plot(Light.DownDurMean,Light.UpDurMean,'kd','MarkerFaceColor','r','LineWidth',1.);
plot(Sleep.DownDurMean+[-1 1]*Sleep.DownDurStd, [1 1]*Sleep.UpDurMean,'k-','LineWidth',1.)
plot([1 1]*Sleep.DownDurMean,Sleep.UpDurMean+[-1 1]*Sleep.UpDurStd,'k-','LineWidth',1.)
plot(Sleep.DownDurMean,Sleep.UpDurMean,'kd','MarkerFaceColor','g','LineWidth',1.);

grid('on')
xlabel('Down duration [s]')
ylabel('Up duration [s]')
title('g_a [mV/s]')

colormap(CM)
hcb = colorbar();
set(hcb,'YLim',ZRange)
caxis(ZRange)

set(gca,'XLim',DurationRange,'YLim',DurationRange);
set(gca,'XScale','log','YScale','log','DataAspectRatio',[1 1 1]);
set(gca,'TickDir','out','Box','on','Layer','top')

FigSize = [5 4];
set(gcf,'PaperUnits','inches','PaperPosition',[0 0 FigSize],'PaperSize',FigSize);
print('-dpdf','GaVsUpDownDurations');

%%
fprintf('Deep: \\nu_{ext} = %.3g Hz, g_a = %.3g mV/s \n', ...
        fnval(stNuExt,[log10(Deep.DownDurMean);log10(Deep.UpDurMean)]), ...
        fnval(stGa,[log10(Deep.DownDurMean);log10(Deep.UpDurMean)]));
fprintf('Light: \\nu_{ext} = %.3g Hz, g_a = %.3g mV/s \n', ...
        fnval(stNuExt,[log10(Light.DownDurMean);log10(Light.UpDurMean)]), ...
        fnval(stGa,[log10(Light.DownDurMean);log10(Light.UpDurMean)]));
fprintf('Sleep: \\nu_{ext} = %.3g Hz, g_a = %.3g mV/s \n', ...
        fnval(stNuExt,[log10(Sleep.DownDurMean);log10(Sleep.UpDurMean)]), ...
        fnval(stGa,[log10(Sleep.DownDurMean);log10(Sleep.UpDurMean)]));
