Ga = 0:5:60;

NuExtMin = 0.77;
NuExtMax = 0.87;
DNuExt = 0.01;
NuExt = [NuExtMin:DNuExt:NuExtMax NuExtMax-DNuExt:-DNuExt:NuExtMin];

StimTime = 10;
tTrans = 0:StimTime:numel(NuExt)*StimTime;

SmoothingWindow = 4; % num. of samples.

FRmean = nan(numel(Ga),numel(NuExt));
FRstd = nan(numel(Ga),numel(NuExt));
FRminmax = nan(numel(Ga),numel(NuExt));

for ng = 1:numel(Ga)
   load(sprintf('g=%g/rates.dat',Ga(ng)));
   t = rates(:,1)/1000;
   NuE = rates(:,2);
   
   dt = diff(t(1:2));
   SamplingRate = 1/diff(t(1:2));
   CutoffFreq = SamplingRate/SmoothingWindow;
   d = designfilt('lowpassfir','CutoffFrequency',CutoffFreq,...
                  'FilterOrder',12,'SampleRate', SamplingRate);
   lpNuE = filtfilt(d,NuE);
   for nn = 1:numel(NuExt)
      ndx = find(t>=tTrans(nn) & t<tTrans(nn+1));
      FRmean(ng,nn) = mean(NuE(ndx));
      FRstd(ng,nn) = std(NuE(ndx));
      FRminmax(ng,nn) = max(lpNuE(ndx)) - min(lpNuE(ndx));
   end
end

%%
ndxMid = ceil(numel(NuExt)/2);
DNu = -(FRmean(:,1:ndxMid) - fliplr(FRmean(:,ndxMid:end)));
NuMean = (FRmean(:,1:ndxMid) + fliplr(FRmean(:,ndxMid:end)))/2;
NuSD = (FRstd(:,1:ndxMid) + fliplr(FRstd(:,ndxMid:end)))/2;
NuMinMax = (FRminmax(:,1:ndxMid) + fliplr(FRminmax(:,ndxMid:end)))/2;

figure
subplot(2,2,1)
imagesc(NuExt(1:ndxMid),Ga,DNu);
colorbar
set(gca,'YDir','norm')
set(gca,'Layer','top','Box','on','TickDir','out')
xlabel('\nu_{ext} [Hz]')
ylabel('g_a [mV/s]')
title('\Delta\nu [Hz]')

subplot(2,2,2)
% imagesc(NuExt(1:ndxMid),Ga,NuSD);
imagesc(NuExt(1:ndxMid),Ga,NuMean);
colorbar
set(gca,'YDir','norm')
set(gca,'Layer','top','Box','on','TickDir','out')
xlabel('\nu_{ext} [Hz]')
ylabel('g_a [mV/s]')
% title('\nu st.dev. [Hz]')
title('mean(\nu) [Hz]')

subplot(2,2,3)
imagesc(NuExt(1:ndxMid),Ga,NuMinMax);
% imagesc(NuExt(1:ndxMid),Ga,NuMinMax./NuMean);
colorbar
set(gca,'YDir','norm')
set(gca,'Layer','top','Box','on','TickDir','out')
xlabel('\nu_{ext} [Hz]')
ylabel('g_a [mV/s]')
title('max(\nu) - min(\nu) [Hz]')
% title('(max(\nu) - min(\nu))/mean(\nu) [Hz]')

subplot(2,2,4)

% States clustering.
NumOfStates = 4; % Bistable, SO, LAS and HAS.
Features = [DNu(:) NuMean(:) NuMinMax(:)];
idxC = kmeans(Features,NumOfStates,'Distance','cityblock','Display','iter');
ClusteredStates = reshape(idxC,size(DNu));

imagesc(NuExt(1:ndxMid),Ga,ClusteredStates);
colorbar
set(gca,'YDir','norm')
set(gca,'Layer','top','Box','on','TickDir','out')
xlabel('\nu_{ext} [Hz]')
ylabel('g_a [mV/s]')
title('Clustered states')

FigSize = [8 6];
set(gcf,'PaperSize',FigSize,'PaperPosition',[0 0 FigSize]);
print('-dpdf','BifurcationDiagram')
savefig('BifurcationDiagram')


%% Checking the quality of the resulting k-means clustering.
figure
[silh,~] = silhouette(Features,idxC,'cityblock');
h = gca;
h.Children.EdgeColor = [.8 .8 1];
xlabel 'Silhouette Value'
ylabel 'Cluster'

