# EPSRC HEED Data Repository: Surveys

The HEED project aims at understanding energy needs of refugees and displaced populations to improve access to clean energy. The focus of HEED is on the lived experiences ofrefugeesliving for protracted periods of time in three refugee camps in Rwanda (Nyabiheke,GihembeandKigeme) and internally displaced persons (IDPs) forced to leave their homes as a result of the 2015 earthquake in Nepal. As part of the project, an energy assessment survey of households in both countries was undertaken using quantitative and qualitative research methods with households living in different parts of the camps/settlements, entrepreneurs running small businesses, and those responsible for community facilities, such as schools and health clinics. In the first phase, a questionnaire-based survey targeting displaced populations was conducted with households living in three refugee camps in Rwanda and four displaced sites in Nepal (see tables 2.1 and 2.2 respectively). The second phase of the field research involved a series of interviews and focus group discussions with various stakeholders in Nepal and Rwanda.?The surveys were designed and delivered between March and April 2018 by the project partner, Practical Action. In both countries, the enumerators for the survey received a two-day training on research methods, data collection and ethics.

With regards to the household survey, the sample size was derived using Cochrans formula as described by Bartlett et. al. in Organizational Research: Determining Appropriate Sample Size in Survey Research. A minimum sample size of 119 households was derived by applying a margin of error of 0.03 and an alpha of 0.5. A breakdown of the focal group and specific sites where the surveys were delivered in Rwanda and Nepal is shown intables 2.1 and 2.2 respectively. In Rwanda, a total of 814 surveys including 622 households, 155 enterprises and 37 community facilities from across three sites were conducted. The sample distribution across camp shows 211 forGihembe, 202 forKigemeand 209 forNyabiheke.InGihembemore than half of the respondents (118, 55.9%) sampled were females with the remaining 93 (44.1%) being males. This is in contrast withKigemewhere almost equal numbers of both male (100,49.5%) and females (102,50.5%) were sampled. InNyabihekethe sample covered more females (123,58.9%) than males (86,41.1%). In Nepal, the sample covered 181 households, 18 enterprises and 3 community facilities (see table 2.2). The household sample in Nepal covered more males (126,69.6%) than females (55,30.4%).

## Folder Structure:

### Survey:
 * Gihembe Community Facility Survey  Gihembe_CF.csv
 * Gihembe Enterprise Survey  Gihembe_EN.csv
 * Gihembe Household Survey  Gihembe_HH.csv
 
 * Kigeme Community Facility Survey  Kigeme_CF.csv
 * Kigeme Enterprise Survey  Kigeme_EN.csv
 * Kigeme Household Survey  Kigeme_HH.csv
 
 * Nepal Community Facility Survey  Nepal_CF.csv
 * Nepal Enterprise Survey  Nepal_EN.csv
 * Nepal Household Survey  Nepal_HH.csv
 
 * Nyabiheke Community Facility Survey - Nyabiheke_CF.csv
 * Nyabiheke Enterprise Survey  Nyabiheke_EN.csv
 * Nyabiheke Household Survey  Nyabiheke_HH.csv

### Location Maps:
 * Gihembe Community Facility Survey Map  CF_GIS_gihembe.csv
 * Gihembe Enterprise Survey Map  EN_GIS_gihembe.csv
 * Gihembe Household Survey Map  HH_GIS_gihembe.csv
 
 * Kigeme Community Facility Survey Map  CF_GIS_kigeme.csv
 * Kigeme Enterprise Survey Map  EN_GIS_kigeme.csv
 * Kigeme Household Survey Map  HH_GIS_kigeme.csv
 
 * Nepal Community Facility Survey Map  CF_GIS_nepal.csv
 * Nepal Enterprise Survey Map  EN_GIS_nepal.csv
 * Nepal Household Survey Map  HH_GIS_nepal.csv
 
 * Nyabiheke Community Facility Survey Map - CF_GIS_nyabiheke.csv
 * Nyabiheke Enterprise Survey Map  EN_GIS_nyabiheke.csv
 * Nyabiheke Household Survey Map  HH_GIS_nyabiheke.csv

The following information was gathered from each of the surveys:
* Households: The datasets contain information about household demographics, access to and use of electricity and lighting technologies, access to and use of cooking technologies and fuels, self-reported needs and priorities by the household, and ownership of energy products. Several key areas, such as solar lighting products and issues around fuel usage, are covered in more detail.
* Enterprises: The datasets contain information about the enterprise, their electrical and non-electrical lighting needs and supply, the usage of energy for ICT and entertainment, motive power, heating, and cooling applications, and their ownership of electrical appliances.
* Community facility: The datasets contain information about the community facility or institution, their electrical and non-electrical lighting needs and supply, the usage of energy for ICT and entertainment, motive power, heating, and cooling applications, and their ownership of electrical appliances. Community facilities offered healthcare services were presented additional questions about specific medical devices.

The survey results together with other methodological tools including field visits, workshops - Design for Displacement (D4D) and Energy for End-Users (E4E) workshops have provided relevant data and contextual knowledge to inform the design of the various interventions associated with the HEED. The data sets and results have been compiled, organised and uploaded in the data portal for use by researchers, students and all both within and outside of the project consortium, during and beyond the project lifetime. 

