# Contributing to CWL-airflow
We appreciate your input! We want to make contributing to this project as easy and transparent as possible, whether it's:

- Reporting a bug
- Discussing the current state of the code
- Submitting a fix
- Proposing new features

## We Develop with Github
We use github to host code, to track issues and feature requests, as well as accept pull requests. We use [Github Flow](https://guides.github.com/introduction/flow/index.html), so all code changes happen through pull requests. We actively welcome your pull requests:

1. Fork the repo and create your branch from `master`
2. If you've added code that should be tested, add tests
4. Ensure the test suite passes
6. Issue that pull request

**Any contributions you make will be under the [Apache-2.0 License](http://www.apache.org/licenses/LICENSE-2.0). Feel free to contact the maintainers if that's a concern.**

## Report bugs using Github's issues
We use GitHub issues to track bugs. Report a bug by opening a new issue. Choose one of the available templates and describe your problem in details following the provided instructions.

## License
By contributing, you agree that your contributions will be licensed under its [Apache-2.0 License](http://www.apache.org/licenses/LICENSE-2.0).

## References
This document was adapted from the [basic template](https://gist.github.com/briandk/3d2e8b3ec8daf5a27a62) for contributing guidelines made on the basis of Facebook's open source guidelines.