## code for:
## A method for mapping morphological convergence on three-dimensional digital models: 
## the case of the mammalian saber-tooth

## Melchionna, M, Profico A., Castiglione S., Serio C., Mondanaro A., Modafferi, M., 
## Tamagnini D.5, Maiorano L.5, Raia P., Witmer L.M., Wroe S., Sansalone G.


# in this .rda you will find:
# bePCs - RW (or PC) vectors (eigenvectors of the covariance matrix) of all the samples
# bescores - relative warp scores of all samples
# df - data.frame with averaged RW scores for the first comparison
# df2 - data.frame with averaged RW scores for the second comparison
# cons.configur - the Consensus configuration


# install RRphylo 
install.packages("devtools")
devtools::install_github("pasraia/RRphylo",build_vignettes = TRUE,dependencies=TRUE)

# load the needed packages
library(RRphylo)
library(rgl)


# run conv.map
# an rgl windows will be open with the comparisons
CM <- conv.map(dataset=df,
               exclude=NULL,
               plot = TRUE,
               conv=NULL,
               names=TRUE,
               show.consensus = TRUE,
               col="dodgerblue2",
               pcs = bePCs,
               mshape = cons.configur)

CM2 <- conv.map(dataset=df2,
               exclude=NULL,
               conv=NULL,
               plot = TRUE,
               show.consensus=TRUE,
               col="dodgerblue2",
               pcs = bePCs,
               mshape = cons.configur)

# visualize pairwise angle comparisons and average area differences
CM$angle.compare
CM$average.dist

CM2$angle.compare
CM2$average.dist


