% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.R
\name{rolling_mad}
\alias{rolling_mad}
\title{Rolling median absolute deviation (MAD)}
\usage{
rolling_mad(x, k)
}
\arguments{
\item{x}{A vector of numbers.}

\item{k}{Width of the rolling window (an odd integer).}
}
\value{
A vector of MADs.
}
\description{
Calculate the median absolute deviation (MAD) of a rolling window of values.
}
\details{
The median absolute deviation (MAD) is a median-based alternative to the
standard deviation often preferred for its robustness to outliers
\insertCite{leys_detecting_2013}{atmoschem.process}. The MAD for a collection
of values \eqn{X} is defined as

\deqn{1.4826 \times \textrm{med}(\left| X - \textrm{med}(X) \right|)}{1.4826 * med(|X - med(X)|)}

where the constant 1.4826 scales the result to estimate the standard
deviation.
}
\examples{
rolling_mad(rnorm(20), 5)

}
\references{
\insertAllCited{}
}
