% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flags.R
\name{hampel_outlier}
\alias{hampel_outlier}
\title{Rolling outlier detection using the Hampel identifier}
\usage{
hampel_outlier(x, k, threshold = 3.5)
}
\arguments{
\item{x}{A vector of numbers.}

\item{k}{Width of the rolling window (an odd integer).}

\item{threshold}{Threshold for labeling outliers. For normally distributed
data this is equivalent to standard deviations.}
}
\value{
A vector of boolean values, TRUE if the value is an outlier.
}
\description{
Detect outliers in a rolling window using the Hampel identifier.
}
\details{
The Hampel identifier uses the median absolute deviation (MAD) and a
threshold to identify outliers based on their distance from the median
\insertCite{davies_identification_1993}{atmoschem.process}. This is a robust
alternative to the commonly used thresholds \eqn{mean \pm 3 \sigma}{mean
+/-3sd} to identify outliers
\insertCite{leys_detecting_2013}{atmoschem.process}.

Values are classified as outliers when

\deqn{\frac{\left| X_i - \textrm{med}(X) \right|}{\textrm{MAD}(X)} >
threshold}{|X_i - med(X)| / MAD(X) > threshold}

When the MAD is zero this equation is undefined. In this case the function
returns FALSE.
}
\examples{
# test a dataset with an outlier
x <- rnorm(20)
x[3] <- 10
hampel_outlier(x, 5)

}
\references{
\insertAllCited{}
}
