

## This file shows how to read the derived velocity models
## The saved velocity models are saved in a single-precision binary format

## unit: m/s
## vel_tomo: velocity model from travel-time tomography
## vel_fwi_1: velocity model from trace-normalized FWI
## vel_fwi_2: velocity model from 'true amplitude' FWI


## sample increment is 20.0 m
## Z direction starts from 0 km 
## X direction starts from - 74 km

import numpy as np

nz = 450

## to read the data

file_data = 'vel_tomo'

with open(file_data,'r') as f:
    seis = np.fromfile(f, dtype=np.float32)
nx_rec=int(len(seis)/nz)
vp = seis.reshape(nx_rec,nz)

## for plotting using seismic_unix in a command window

#ximage n1=450 <vel_tomo d1=0.02 d2=0.02 f1=0 f2=-74 x2beg=106 x2end=202 x1end=9 



