
## This file shows how to read the processed OBS data
## The processed OBS data is saved in a double-precision binary format

## time sample increment is 0.0011
## the picked travel times, source position, OBS position et al is stored at directory ./info

import numpy as np

nt=12000

dt = 0.0011

file_data = 'obs_ffid_0056hydr'

with open(file_data,'r') as f:
    seis = np.fromfile(f, dtype=np.float64)
nx_rec=int(len(seis)/nt)
seis_p = seis.reshape(nx_rec,nt,order='F')

## seis_p is a two-D matrix now, you may use matplotlib to plot it. 
## if seismic unix is the preferred plotting tool, you can save it as single-precision binary format using 

file_out = 'data.bin'
seis_p.astype(np.float32).tofile(file_out)



