// -*- C++ -*-
//
// ======================================================================
//
// Brad T. Aagaard, U.S. Geological Survey
// Charles A. Williams, GNS Science
// Matthew G. Knepley, University of Chicago
//
// This code was developed as part of the Computational Infrastructure
// for Geodynamics (http://geodynamics.org).
//
// Copyright (c) 2010-2017 University of California, Davis
//
// See COPYING for license information.
//
// ======================================================================
//

// DO NOT EDIT THIS FILE
// This file was generated from python application quadratureapp.

#include "QuadratureData2Din3DQuadratic.hh"

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_numVertices = 6;

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_spaceDim = 3;

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_numCells = 1;

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_cellDim = 2;

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_numBasis = 6;

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_numQuadPts = 6;

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_vertices[] = {
  2.00000000e+00, -5.00000000e-01, -5.00000000e-01,
  5.00000000e-01,  3.00000000e+00,  0.00000000e+00,
 -5.00000000e-01,  0.00000000e+00,  2.00000000e+00,
  0.00000000e+00,  1.50000000e+00,  1.00000000e+00,
  7.50000000e-01, -2.50000000e-01,  7.50000000e-01,
  1.25000000e+00,  1.25000000e+00, -2.50000000e-01,
};

const int pylith::feassemble::QuadratureData2Din3DQuadratic::_cells[] = {
       0,       1,       2,       3,       4,       5,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_verticesRef[] = {
 -1.00000000e+00, -1.00000000e+00,
  1.00000000e+00, -1.00000000e+00,
 -1.00000000e+00,  1.00000000e+00,
  0.00000000e+00,  0.00000000e+00,
 -1.00000000e+00,  0.00000000e+00,
  0.00000000e+00, -1.00000000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_quadPtsRef[] = {
 -7.50000000e-01, -7.50000000e-01,
  7.50000000e-01, -7.50000000e-01,
 -7.50000000e-01,  7.50000000e-01,
  0.00000000e+00, -7.50000000e-01,
 -7.50000000e-01,  0.00000000e+00,
  2.50000000e-01,  2.50000000e-01,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_quadWts[] = {
  3.33333333e-01,  3.33333333e-01,  3.33333333e-01,  3.33333333e-01,  3.33333333e-01,  3.33333333e-01,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_quadPts[] = {
  1.50000000e+00,  0.00000000e+00, -1.25000000e-01,
  3.75000000e-01,  2.62500000e+00,  2.50000000e-01,
 -3.75000000e-01,  3.75000000e-01,  1.75000000e+00,
  9.37500000e-01,  1.31250000e+00,  6.25000000e-02,
  5.62500000e-01,  1.87500000e-01,  8.12500000e-01,
 -5.00000000e-01,  2.00000000e+00,  1.37500000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_basis[] = {
  3.75000000e-01, -9.37500000e-02,
 -9.37500000e-02,  6.25000000e-02,
  3.75000000e-01,  3.75000000e-01,
  0.00000000e+00,  6.56250000e-01,
 -9.37500000e-02,  4.37500000e-01,
 -0.00000000e+00, -0.00000000e+00,
  0.00000000e+00, -9.37500000e-02,
  6.56250000e-01,  4.37500000e-01,
 -0.00000000e+00, -0.00000000e+00,
 -9.37500000e-02,  0.00000000e+00,
 -9.37500000e-02,  2.50000000e-01,
  1.87500000e-01,  7.50000000e-01,
 -9.37500000e-02, -9.37500000e-02,
  0.00000000e+00,  2.50000000e-01,
  7.50000000e-01,  1.87500000e-01,
  3.75000000e-01,  1.56250000e-01,
  1.56250000e-01,  1.56250000e+00,
 -6.25000000e-01, -6.25000000e-01,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_basisDerivRef[] = {
 -1.00000000e+00, -1.00000000e+00,
 -2.50000000e-01,  0.00000000e+00,
  0.00000000e+00, -2.50000000e-01,
  2.50000000e-01,  2.50000000e-01,
 -2.50000000e-01,  1.25000000e+00,
  1.25000000e+00, -2.50000000e-01,
  5.00000000e-01,  5.00000000e-01,
  1.25000000e+00,  0.00000000e+00,
  0.00000000e+00, -2.50000000e-01,
  2.50000000e-01,  1.75000000e+00,
 -2.50000000e-01, -2.50000000e-01,
 -1.75000000e+00, -1.75000000e+00,
  5.00000000e-01,  5.00000000e-01,
 -2.50000000e-01,  0.00000000e+00,
  0.00000000e+00,  1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
 -1.75000000e+00, -1.75000000e+00,
 -2.50000000e-01, -2.50000000e-01,
 -2.50000000e-01, -2.50000000e-01,
  5.00000000e-01,  0.00000000e+00,
  0.00000000e+00, -2.50000000e-01,
  2.50000000e-01,  1.00000000e+00,
 -2.50000000e-01,  5.00000000e-01,
 -2.50000000e-01, -1.00000000e+00,
 -2.50000000e-01, -2.50000000e-01,
 -2.50000000e-01,  0.00000000e+00,
  0.00000000e+00,  5.00000000e-01,
  1.00000000e+00,  2.50000000e-01,
 -1.00000000e+00, -2.50000000e-01,
  5.00000000e-01, -2.50000000e-01,
  1.00000000e+00,  1.00000000e+00,
  7.50000000e-01,  0.00000000e+00,
  0.00000000e+00,  7.50000000e-01,
  1.25000000e+00,  1.25000000e+00,
 -1.25000000e+00, -1.75000000e+00,
 -1.75000000e+00, -1.25000000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_basisDeriv[] = {
  7.50000000e-01, -2.50000000e-01, -7.05882353e-01,
 -3.12500000e-02, -1.56250000e-01,  2.94117647e-02,
  2.18750000e-01,  9.37500000e-02, -2.05882353e-01,
 -1.87500000e-01,  6.25000000e-02,  1.76470588e-01,
 -1.12500000e+00, -6.25000000e-01,  1.05882353e+00,
  3.75000000e-01,  8.75000000e-01, -3.52941176e-01,
 -3.75000000e-01,  1.25000000e-01,  3.52941176e-01,
  1.56250000e-01,  7.81250000e-01, -1.47058824e-01,
  2.18750000e-01,  9.37500000e-02, -2.05882353e-01,
 -1.50000000e+00, -5.00000000e-01,  1.41176471e+00,
  1.87500000e-01, -6.25000000e-02, -1.76470588e-01,
  1.31250000e+00, -4.37500000e-01, -1.23529412e+00,
 -3.75000000e-01,  1.25000000e-01,  3.52941176e-01,
 -3.12500000e-02, -1.56250000e-01,  2.94117647e-02,
 -1.09375000e+00, -4.68750000e-01,  1.02941176e+00,
  0.00000000e+00,  1.00000000e+00,  2.77555756e-17,
  1.31250000e+00, -4.37500000e-01, -1.23529412e+00,
  1.87500000e-01, -6.25000000e-02, -1.76470588e-01,
  1.87500000e-01, -6.25000000e-02, -1.76470588e-01,
  6.25000000e-02,  3.12500000e-01, -5.88235294e-02,
  2.18750000e-01,  9.37500000e-02, -2.05882353e-01,
 -8.43750000e-01, -2.18750000e-01,  7.94117647e-01,
 -4.68750000e-01, -3.43750000e-01,  4.41176471e-01,
  8.43750000e-01,  2.18750000e-01, -7.94117647e-01,
  1.87500000e-01, -6.25000000e-02, -1.76470588e-01,
 -3.12500000e-02, -1.56250000e-01,  2.94117647e-02,
 -4.37500000e-01, -1.87500000e-01,  4.11764706e-01,
 -9.37500000e-02,  5.31250000e-01,  8.82352941e-02,
  9.37500000e-02, -5.31250000e-01, -8.82352941e-02,
  2.81250000e-01,  4.06250000e-01, -2.64705882e-01,
 -7.50000000e-01,  2.50000000e-01,  7.05882353e-01,
  9.37500000e-02,  4.68750000e-01, -8.82352941e-02,
 -6.56250000e-01, -2.81250000e-01,  6.17647059e-01,
 -9.37500000e-01,  3.12500000e-01,  8.82352941e-01,
  1.37500000e+00, -1.25000000e-01, -1.29411765e+00,
  8.75000000e-01, -6.25000000e-01, -8.23529412e-01,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_jacobian[] = {
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
 -7.50000000e-01, -1.25000000e+00,
  1.75000000e+00,  2.50000000e-01,
  2.50000000e-01,  1.25000000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_jacobianDet[] = {
  2.98433410e+00,  2.98433410e+00,  2.98433410e+00,  2.98433410e+00,  2.98433410e+00,  2.98433410e+00,
};

const PylithScalar pylith::feassemble::QuadratureData2Din3DQuadratic::_jacobianInv[] = {
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
  1.25000000e-01,  6.25000000e-01, -1.17647059e-01,
 -8.75000000e-01, -3.75000000e-01,  8.23529412e-01,
};

pylith::feassemble::QuadratureData2Din3DQuadratic::QuadratureData2Din3DQuadratic(void)
{ // constructor
  numVertices = _numVertices;
  spaceDim = _spaceDim;
  numCells = _numCells;
  cellDim = _cellDim;
  numBasis = _numBasis;
  numQuadPts = _numQuadPts;
  vertices = const_cast<PylithScalar*>(_vertices);
  cells = const_cast<int*>(_cells);
  verticesRef = const_cast<PylithScalar*>(_verticesRef);
  quadPtsRef = const_cast<PylithScalar*>(_quadPtsRef);
  quadWts = const_cast<PylithScalar*>(_quadWts);
  quadPts = const_cast<PylithScalar*>(_quadPts);
  basis = const_cast<PylithScalar*>(_basis);
  basisDerivRef = const_cast<PylithScalar*>(_basisDerivRef);
  basisDeriv = const_cast<PylithScalar*>(_basisDeriv);
  jacobian = const_cast<PylithScalar*>(_jacobian);
  jacobianDet = const_cast<PylithScalar*>(_jacobianDet);
  jacobianInv = const_cast<PylithScalar*>(_jacobianInv);
} // constructor

pylith::feassemble::QuadratureData2Din3DQuadratic::~QuadratureData2Din3DQuadratic(void)
{}


// End of file
