// -*- C++ -*-
//
// ======================================================================
//
// Brad T. Aagaard, U.S. Geological Survey
// Charles A. Williams, GNS Science
// Matthew G. Knepley, University of Chicago
//
// This code was developed as part of the Computational Infrastructure
// for Geodynamics (http://geodynamics.org).
//
// Copyright (c) 2010-2017 University of California, Davis
//
// See COPYING for license information.
//
// ======================================================================
//

// DO NOT EDIT THIS FILE
// This file was generated from python application quadratureapp.

#include "QuadratureData1Din2DQuadratic.hh"

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_numVertices = 3;

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_spaceDim = 2;

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_numCells = 1;

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_cellDim = 1;

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_numBasis = 3;

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_numQuadPts = 2;

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_vertices[] = {
 -2.00000000e-01, -5.00000000e-01,
  7.00000000e-01,  3.00000000e-01,
  2.50000000e-01, -1.00000000e-01,
};

const int pylith::feassemble::QuadratureData1Din2DQuadratic::_cells[] = {
       0,       1,       2,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_verticesRef[] = {
 -1.00000000e+00,
  1.00000000e+00,
  0.00000000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_quadPtsRef[] = {
 -5.77350269e-01,
  5.77350269e-01,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_quadWts[] = {
  1.00000000e+00,  1.00000000e+00,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_quadPts[] = {
 -9.80762114e-03, -3.30940108e-01,
  5.09807621e-01,  1.30940108e-01,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_basis[] = {
  4.55341801e-01,
 -1.22008468e-01,
  6.66666667e-01,
 -1.22008468e-01,
  4.55341801e-01,
  6.66666667e-01,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_basisDerivRef[] = {
 -1.07735027e+00,
 -7.73502692e-02,
  1.15470054e+00,
  7.73502692e-02,
  1.07735027e+00,
 -1.15470054e+00,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_basisDeriv[] = {
 -2.39411171e+00, -2.69337567e+00,
 -1.71889487e-01, -1.93375673e-01,
  2.56600120e+00,  2.88675135e+00,
  1.71889487e-01,  1.93375673e-01,
  2.39411171e+00,  2.69337567e+00,
 -2.56600120e+00, -2.88675135e+00,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_jacobian[] = {
  4.50000000e-01,
  4.00000000e-01,
  4.50000000e-01,
  4.00000000e-01,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_jacobianDet[] = {
  6.02079729e-01,  6.02079729e-01,
};

const PylithScalar pylith::feassemble::QuadratureData1Din2DQuadratic::_jacobianInv[] = {
  2.22222222e+00,  2.50000000e+00,
  2.22222222e+00,  2.50000000e+00,
};

pylith::feassemble::QuadratureData1Din2DQuadratic::QuadratureData1Din2DQuadratic(void)
{ // constructor
  numVertices = _numVertices;
  spaceDim = _spaceDim;
  numCells = _numCells;
  cellDim = _cellDim;
  numBasis = _numBasis;
  numQuadPts = _numQuadPts;
  vertices = const_cast<PylithScalar*>(_vertices);
  cells = const_cast<int*>(_cells);
  verticesRef = const_cast<PylithScalar*>(_verticesRef);
  quadPtsRef = const_cast<PylithScalar*>(_quadPtsRef);
  quadWts = const_cast<PylithScalar*>(_quadWts);
  quadPts = const_cast<PylithScalar*>(_quadPts);
  basis = const_cast<PylithScalar*>(_basis);
  basisDerivRef = const_cast<PylithScalar*>(_basisDerivRef);
  basisDeriv = const_cast<PylithScalar*>(_basisDeriv);
  jacobian = const_cast<PylithScalar*>(_jacobian);
  jacobianDet = const_cast<PylithScalar*>(_jacobianDet);
  jacobianInv = const_cast<PylithScalar*>(_jacobianInv);
} // constructor

pylith::feassemble::QuadratureData1Din2DQuadratic::~QuadratureData1Din2DQuadratic(void)
{}


// End of file
