// -*- C++ -*-
//
// ======================================================================
//
// Brad T. Aagaard, U.S. Geological Survey
// Charles A. Williams, GNS Science
// Matthew G. Knepley, University of Chicago
//
// This code was developed as part of the Computational Infrastructure
// for Geodynamics (http://geodynamics.org).
//
// Copyright (c) 2010-2017 University of California, Davis
//
// See COPYING for license information.
//
// ======================================================================
//

// DO NOT EDIT THIS FILE
// This file was generated from python application elasticitylgdeformexplicitapp.

#include "ElasticityExplicitLgDeformGravData3DLinear.hh"

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_spaceDim = 3;

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_cellDim = 3;

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_numVertices = 4;

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_numCells = 1;

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_numBasis = 4;

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_numQuadPts = 1;

const char* pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_matType = "ElasticIsotropic3D";

const char* pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_matDBFilename = "data/elasticisotropic3d.spatialdb";

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_matId = 0;

const char* pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_matLabel = "elastic isotropic 3-D";

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_dt =   1.00000000e-02;

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_dtStableExplicit =   1.80277564e-04;

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_gravityVec[] = {
  0.00000000e+00,  0.00000000e+00, -1.00000000e+08,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_vertices[] = {
 -5.00000000e-01, -1.00000000e+00, -5.00000000e-01,
  2.00000000e+00, -5.00000000e-01, -4.00000000e-01,
  1.00000000e+00, -1.00000000e-01, -3.00000000e-01,
 -2.00000000e-01,  5.00000000e-01,  2.00000000e+00,
};

const int pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_cells[] = {
0,1,2,3,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_verticesRef[] = {
 -1.00000000e+00, -1.00000000e+00, -1.00000000e+00,
  1.00000000e+00, -1.00000000e+00, -1.00000000e+00,
 -1.00000000e+00,  1.00000000e+00, -1.00000000e+00,
 -1.00000000e+00, -1.00000000e+00,  1.00000000e+00,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_quadPts[] = {
 -5.00000000e-01, -5.00000000e-01, -5.00000000e-01,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_quadWts[] = {
  1.33333333e+00,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_basis[] = {
  2.50000000e-01,  2.50000000e-01,  2.50000000e-01,
  2.50000000e-01,};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_basisDerivRef[] = {
 -5.00000000e-01, -5.00000000e-01, -5.00000000e-01,
  5.00000000e-01,  0.00000000e+00,  0.00000000e+00,
  0.00000000e+00,  5.00000000e-01,  0.00000000e+00,
  0.00000000e+00,  0.00000000e+00,  5.00000000e-01,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_fieldTIncr[] = {
  3.00000000e-01,  2.00000000e-01, -5.00000000e-01,
 -3.00000000e-01, -4.00000000e-01, -6.00000000e-01,
  2.00000000e-01,  6.00000000e-01,  3.00000000e-01,
 -6.00000000e-01, -1.00000000e-01, -3.00000000e-01,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_fieldT[] = {
  8.00000000e-01,  1.00000000e-01, -6.00000000e-01,
 -1.00000000e-01, -2.00000000e-01, -5.00000000e-01,
  1.00000000e-01,  7.00000000e-01,  2.00000000e-01,
 -5.00000000e-01, -0.00000000e+00, -2.00000000e-01,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_fieldTmdt[] = {
  1.00000000e-01,  1.00000000e-01, -3.00000000e-01,
 -2.00000000e-01, -1.00000000e-01, -5.00000000e-01,
  2.00000000e-01,  4.00000000e-01,  1.00000000e-01,
 -4.00000000e-01, -1.00000000e-01, -1.00000000e-01,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_valsResidual[] = {
 -1.49483992e+10,  3.54043006e+11,  1.46832161e+11,
 -6.03838259e+10,  7.78381411e+11,  3.40227176e+11,
  7.04794221e+10, -1.26218270e+12, -6.31967244e+11,
  4.85616550e+09,  1.29758280e+11,  1.04105970e+10,
};

const PylithScalar pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::_valsJacobian[] = {
  3.36250000e+06,  3.36250000e+06,  3.36250000e+06,
  3.36250000e+06,  3.36250000e+06,  3.36250000e+06,
  3.36250000e+06,  3.36250000e+06,  3.36250000e+06,
  3.36250000e+06,  3.36250000e+06,  3.36250000e+06,
};

pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::ElasticityExplicitLgDeformGravData3DLinear(void)
{ // constructor
  spaceDim = _spaceDim;
  cellDim = _cellDim;
  numVertices = _numVertices;
  numCells = _numCells;
  numBasis = _numBasis;
  numQuadPts = _numQuadPts;
  matType = const_cast<char*>(_matType);
  matDBFilename = const_cast<char*>(_matDBFilename);
  matId = _matId;
  matLabel = const_cast<char*>(_matLabel);
  dt = _dt;
  dtStableExplicit = _dtStableExplicit;
  gravityVec = const_cast<PylithScalar*>(_gravityVec);
  vertices = const_cast<PylithScalar*>(_vertices);
  cells = const_cast<int*>(_cells);
  verticesRef = const_cast<PylithScalar*>(_verticesRef);
  quadPts = const_cast<PylithScalar*>(_quadPts);
  quadWts = const_cast<PylithScalar*>(_quadWts);
  basis = const_cast<PylithScalar*>(_basis);
  basisDerivRef = const_cast<PylithScalar*>(_basisDerivRef);
  fieldTIncr = const_cast<PylithScalar*>(_fieldTIncr);
  fieldT = const_cast<PylithScalar*>(_fieldT);
  fieldTmdt = const_cast<PylithScalar*>(_fieldTmdt);
  valsResidual = const_cast<PylithScalar*>(_valsResidual);
  valsJacobian = const_cast<PylithScalar*>(_valsJacobian);
} // constructor

pylith::feassemble::ElasticityExplicitLgDeformGravData3DLinear::~ElasticityExplicitLgDeformGravData3DLinear(void)
{}


// End of file
