// -*- C++ -*-
//
// ======================================================================
//
// Brad T. Aagaard, U.S. Geological Survey
// Charles A. Williams, GNS Science
// Matthew G. Knepley, University of Chicago
//
// This code was developed as part of the Computational Infrastructure
// for Geodynamics (http://geodynamics.org).
//
// Copyright (c) 2010-2017 University of California, Davis
//
// See COPYING for license information.
//
// ======================================================================
//

#include "AbsorbingDampersDataHex8.hh"

const char* pylith::bc::AbsorbingDampersDataHex8::_meshFilename = 
  "data/hex8.mesh";

const int pylith::bc::AbsorbingDampersDataHex8::_numBasis = 4;
const int pylith::bc::AbsorbingDampersDataHex8::_numQuadPts = 4;
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_quadPts[] = {
  -0.57735027, -0.57735027,
   0.57735027, -0.57735027,
   0.57735027,  0.57735027,
  -0.57735027,  0.57735027,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_quadWts[] = {
  1.0, 1.0, 1.0, 1.0,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_basis[] = {
  0.62200847,  0.16666667,  0.0446582,   0.16666667,
  0.16666667,  0.62200847,  0.16666667,  0.0446582,
  0.0446582,   0.16666667,  0.62200847,  0.16666667,
  0.16666667,  0.0446582,   0.16666667,  0.62200847,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_basisDerivRef[] = {
  -0.39433757, -0.39433757,
   0.39433757, -0.10566243,
   0.10566243,  0.10566243,
  -0.10566243,  0.39433757,
  -0.39433757, -0.10566243,
   0.39433757, -0.39433757,
   0.10566243,  0.39433757,
  -0.10566243,  0.10566243,
  -0.10566243, -0.10566243,
   0.10566243, -0.39433757,
   0.39433757,  0.39433757,
  -0.39433757,  0.10566243,
  -0.10566243, -0.39433757,
   0.10566243, -0.10566243,
   0.39433757,  0.10566243,
  -0.39433757,  0.39433757,
};

const char* pylith::bc::AbsorbingDampersDataHex8::_spatialDBFilename = 
  "data/elasticisotropic3d.spatialdb";
const int pylith::bc::AbsorbingDampersDataHex8::_id = 2;
const char* pylith::bc::AbsorbingDampersDataHex8::_label = "bc2";

const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_dt =   0.25;
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_fieldTmdt[] = {
  1.0,  2.4,  3.0,
  1.1,  2.2,  3.2,
  1.2,  2.0,  3.4,
  1.3,  1.8,  3.6,
  1.4,  1.6,  3.8,
  1.5,  1.4,  4.0,
  1.6,  1.2,  4.2,
  1.7,  1.0,  4.4,
  1.8,  0.8,  4.6,
  1.9,  0.6,  4.8,
  2.0,  0.4,  5.0,
  2.1,  0.2,  5.2,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_fieldT[] = {
  1.1,  2.3,  3.2,
  1.3,  2.1,  3.6,
  1.5,  1.9,  4.0,
  1.7,  1.7,  4.4,
  1.9,  1.5,  4.8,
  2.1,  1.3,  5.2,
  2.3,  1.1,  5.6,
  2.5,  0.9,  6.0,
  2.7,  0.7,  6.4,
  2.9,  0.5,  6.8,
  3.1,  0.3,  7.2,
  3.3,  0.1,  7.6,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_fieldTIncr[] = {
  1.2,  1.1,  3.4,
  1.5,  1.0,  4.0,
  1.8,  0.9,  4.6,
  2.1,  0.8,  5.2,
  2.4,  0.7,  5.8,
  2.7,  0.6,  6.4,
  3.0,  0.5,  7.0,
  3.3,  0.4,  7.6,
  3.6,  0.3,  8.2,
  3.9,  0.2,  8.8,
  4.2,  0.1,  9.4,
  4.5,  0.0, 10.0,
};

const int pylith::bc::AbsorbingDampersDataHex8::_spaceDim = 3;
const int pylith::bc::AbsorbingDampersDataHex8::_cellDim = 2;
const int pylith::bc::AbsorbingDampersDataHex8::_numVertices = 6;
const int pylith::bc::AbsorbingDampersDataHex8::_numCells = 2;
const int pylith::bc::AbsorbingDampersDataHex8::_numCorners = 4;
/* Now vertices are renumbered in the submesh */
const int pylith::bc::AbsorbingDampersDataHex8::_cells[] = {
  2 /*2*/, 3 /*4*/, 6 /*10*/, 5 /*8*/,
  3 /*4*/, 4 /*6*/, 7 /*12*/, 6 /*10*/,
};


const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_dampingConsts[] = {
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
  7.5e+06,  1.25e+07,  7.5e+06,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_valsResidual[] = {
   -1.77500004e+07,   -9.16666682e+06,   -4.30000010e+07,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
   -4.35000010e+07,   -1.50000003e+07,   -1.02000002e+08,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
   -2.57500005e+07,   -5.83333344e+06,   -5.90000012e+07,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
   -2.37500004e+07,   -6.66666681e+06,   -5.50000010e+07,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
   -5.55000010e+07,   -1.00000002e+07,   -1.26000002e+08,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
   -3.17500006e+07,   -3.33333343e+06,   -7.10000013e+07,
    0.00000000e+00,    0.00000000e+00,    0.00000000e+00,
};
const PylithScalar pylith::bc::AbsorbingDampersDataHex8::_valsJacobian[] = {
  3.33333333e+06, 0.0, 0.0, // 0x
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 6
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 0y
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 6
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 0z
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 6
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 1x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 1y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 1z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 2x
  0.0, 0.0, 0.0,
  6.66666667e+06, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 4
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 6
  0.0, 0.0, 0.0,
  3.33333333e+06, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 2y
  0.0, 0.0, 0.0,
  0.0, 1.11111111e+07, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 6
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 2z
  0.0, 0.0, 0.0,
  0.0, 0.0, 6.66666667e+06, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 6
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 3x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 3y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 3z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 4x
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  3.33333333e+06, 0.0, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 4y
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 4z
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 5x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 5y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 5z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 6x
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  3.33333333e+06, 0.0, 0.0, // 6
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 6y
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 6
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 6z
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 6
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 7x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 7y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 7z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 8x
  0.0, 0.0, 0.0,
  3.33333333e+06, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 4
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 6
  0.0, 0.0, 0.0,
  6.66666667e+06, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 8y
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 6
  0.0, 0.0, 0.0,
  0.0, 1.11111111e+07, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 8z
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 6
  0.0, 0.0, 0.0,
  0.0, 0.0, 6.66666667e+06, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 9x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 9y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 9z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 10x
  0.0, 0.0, 0.0,
  8.33333333e+05, 0.0, 0.0, // 2
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  1.66666667e+06, 0.0, 0.0, // 8
  0.0, 0.0, 0.0,
  3.33333333e+06, 0.0, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 10y
  0.0, 0.0, 0.0,
  0.0, 1.38888889e+06, 0.0, // 2
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 2.77777778e+06, 0.0, // 8
  0.0, 0.0, 0.0,
  0.0, 5.55555556e+06, 0.0, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 10z
  0.0, 0.0, 0.0,
  0.0, 0.0, 8.33333333e+05, // 2
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 4
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 1.66666667e+06, // 8
  0.0, 0.0, 0.0,
  0.0, 0.0, 3.33333333e+06, // 10
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 11x
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 11y
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0, // 11z
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
  0.0, 0.0, 0.0,
};

pylith::bc::AbsorbingDampersDataHex8::AbsorbingDampersDataHex8(void)
{ // constructor
  meshFilename = const_cast<char*>(_meshFilename);

  numBasis = _numBasis;
  numQuadPts = _numQuadPts;
  quadPts = const_cast<PylithScalar*>(_quadPts);
  quadWts = const_cast<PylithScalar*>(_quadWts);
  basis = const_cast<PylithScalar*>(_basis);
  basisDerivRef = const_cast<PylithScalar*>(_basisDerivRef);

  spatialDBFilename = const_cast<char*>(_spatialDBFilename);
  id = _id;
  label = const_cast<char*>(_label);

  dt = _dt;
  fieldTIncr = const_cast<PylithScalar*>(_fieldTIncr);
  fieldT = const_cast<PylithScalar*>(_fieldT);
  fieldTmdt = const_cast<PylithScalar*>(_fieldTmdt);

  spaceDim = _spaceDim;
  cellDim = _cellDim;
  numVertices = _numVertices;
  numCells = _numCells;
  numCorners = _numCorners;
  cells = const_cast<int*>(_cells);

  dampingConsts = const_cast<PylithScalar*>(_dampingConsts);
  valsResidual = const_cast<PylithScalar*>(_valsResidual);
  valsJacobian = const_cast<PylithScalar*>(_valsJacobian);
} // constructor

pylith::bc::AbsorbingDampersDataHex8::~AbsorbingDampersDataHex8(void)
{}


// End of file
