// wateroutlet coordinates
pNorth = 5199895
pEast = 725815

//     ----  execute  ----

Wateroutlet _wateroutlet = new Wateroutlet();
_wateroutlet.pNorth = pNorth
_wateroutlet.pEast = pEast
_wateroutlet.inFlow = Rpath + drain + '.asc'
_wateroutlet.outBasin = Rpath + msk + '.asc'
_wateroutlet.process();

map= [pit,drain,tca]
for ( i in map ) {
  CutOut _cutout = new CutOut();
  _cutout.inRaster = Rpath + i + '.asc'
  _cutout.inMask = Rpath + msk + '.asc'
  _cutout.doInverse = false
  _cutout.outRaster = Rpath + prf + i + '.asc'
  _cutout.process();
}


for ( i in pThres ) {
  println	"Soglia tca =" + i
    // ---- network map ----
    // extract network raster
    ExtractNetwork _extractnet = new ExtractNetwork();
    _extractnet.inTca = Rpath + prf + tca + '.asc'
    _extractnet.pThres = i
    _extractnet.pMode = 'tca'
    _extractnet.pExp = 0.5
    _extractnet.outNet = Rpath + prf + net + i + '_m1' + '.asc'
    _extractnet.process();

    // raster subbasin
    NetNumbering _netnum = new NetNumbering();
    _netnum.inFlow = Rpath + prf + drain + '.asc'
    _netnum.inNet = Rpath + prf + net + i + '_m1' + '.asc'
    _netnum.outNetnum = Rpath + prf + nn + i + '.asc'
    _netnum.outBasins = Rpath + prf + sb + i + '.asc'
    _netnum.process();

    // vector network
    NetworkAttributesBuilder _extractvectornet = new NetworkAttributesBuilder();
    _extractvectornet.inNet = Rpath + prf + net + i + '_m1' + '.asc'
    _extractvectornet.inFlow = Rpath + prf + drain + '.asc'
    _extractvectornet.inTca = Rpath + prf + tca + '.asc'
    _extractvectornet.doHack = false
    _extractvectornet.outNet = Vpath + net + i + '.shp'
    _extractvectornet.process();

    // add geometry column (channel length)
    VectorReshaper _reshape = new VectorReshaper();
    _reshape.inVector = Vpath + net + i + '.shp'
    _reshape.pCql = """len=geomLength(the_geom)"""
    _reshape.outVector = Vpath + net + i + '.shp'
    _reshape.process();

    // add netnumber to network
    RasterCatToFeatureAttribute _rat2featureattr = new RasterCatToFeatureAttribute();
    _rat2featureattr.inRaster = Rpath + prf + sb + i + '.asc'
    _rat2featureattr.inVector = Vpath + net + i + '.shp'
    _rat2featureattr.fNew = 'netnum'
    _rat2featureattr.pPos = 'middle'
    _rat2featureattr.outVector = Vpath + net + i + '.shp'
    _rat2featureattr.process();

    // round netnum to integer
    VectorReshaper _reshapeInt = new VectorReshaper();
    _reshapeInt.inVector = Vpath + net + i + '.shp'
    _reshapeInt.pCql = """netnum=round(netnum)"""
    _reshapeInt.outVector = Vpath + net + i + '.shp'
    _reshapeInt.process();

    // add elevation end net
    RasterCatToFeatureAttribute _rat2featureattrMin = new RasterCatToFeatureAttribute();
    _rat2featureattrMin.inRaster = Rpath + prf + pit + '.asc'
    _rat2featureattrMin.inVector = Vpath + net + i + '.shp'
    _rat2featureattrMin.fNew = 'minZ'
    _rat2featureattrMin.pPos = 'end'
    _rat2featureattrMin.outVector = Vpath + net + i + '.shp'
    _rat2featureattrMin.process();

    // add elevation start net
    RasterCatToFeatureAttribute _rat2featureattrMax = new RasterCatToFeatureAttribute();
    _rat2featureattrMax.inRaster = Rpath + prf + pit + '.asc'
    _rat2featureattrMax.inVector = Vpath + net + i + '.shp'
    _rat2featureattrMax.fNew = 'maxZ'
    _rat2featureattrMax.pPos = 'start'
    _rat2featureattrMax.outVector = Vpath + net + i + '.shp'
    _rat2featureattrMax.process();

    // extract vector subbasin
    BasinShape basinshape = new BasinShape();
    basinshape.inElev = Rpath + dtm + '.asc'
    basinshape.inBasins = Rpath + prf + sb + i + '.asc'
    basinshape.outBasins = Vpath + sb + i  + '.shp'
    basinshape.process();

    // extract subbasin centroids
    VectorReshaper _reshCentroid = new VectorReshaper();
    _reshCentroid.inVector = Vpath + sb + i + '.shp'
    _reshCentroid.pCql = """the_geom=centroid(the_geom)"""
    _reshCentroid.outVector = Vpath + ctrd + i + '.shp'
    _reshCentroid.process();
}

// ---- other maps ----

// vector basin mask
Vectorizer _vectorizer = new Vectorizer();
_vectorizer.inRaster = Rpath + msk + '.asc'
_vectorizer.fDefault = 'value'
_vectorizer.pThres = 0.0
_vectorizer.doRegioncheck = false
_vectorizer.outVector = Vpath + msk + '.shp'
_vectorizer.process();


// skyview factor
Skyview _skyview = new Skyview();
_skyview.inElev = Rpath + prf + pit + '.asc'
_skyview.outSky = Rpath + sky + '.asc'
_skyview.process();

// hillshade
Hillshade _hillshade = new Hillshade();
_hillshade.inElev = Rpath + prf + pit + '.asc'
_hillshade.pMinDiffuse = 0.2
_hillshade.pAzimuth = 270.0
_hillshade.pElev = 45.0
_hillshade.outHill = Rpath + hillsh + '.asc'
_hillshade.process();
