import org.jgrasstools.modules.*

// ----  Configuration ----

// path to maps folders
Rpath= '@df/mappe/Raintal/raster/'
Vpath = '@df/mappe/Raintal/vector/'

// DEM name
dtm = 'DTM_Raintal_solchi'

// output maps names
pit = dtm + '_depit'
flow = 'FlowDir'
drain = 'DrainDir'
tca = 'Tca'
net = 'Network'
msk = 'Mask_Basin_Idr'
nn = 'NetNumb'
sb = 'SubBasin'
ctrd = 'Centroid'
sky = 'SkyviewFactor'
hillsh = 'ShadedRelief'

// threshold on Tca to extract network
pThres = [3500,4000,4500]

// prefix for cutted maps
prf = 'C_'

// ---- tools execution  ----  

Pitfiller _pit = new Pitfiller();
_pit.inElev = Rpath + dtm + '.asc'
_pit.outPit = Rpath + pit + '.asc'
_pit.process();

FlowDirections _flow = new FlowDirections();
_flow.inPit = Rpath + pit + '.asc'
_flow.outFlow = Rpath + flow + '.asc'
_flow.process();

DrainDir _draindir = new DrainDir();
_draindir.inPit = Rpath + pit + '.asc'
_draindir.inFlow = Rpath + flow + '.asc'
_draindir.pLambda = 1.0
_draindir.doLad = true
_draindir.outFlow = Rpath + drain + '.asc'
_draindir.outTca = Rpath + tca + '.asc'
_draindir.process();

ExtractNetwork _extractnet_init = new ExtractNetwork();
_extractnet_init.inTca = Rpath + tca + '.asc'
_extractnet_init.pThres = pThres[0]
_extractnet_init.pMode = 'tca'
_extractnet_init.pExp = 0.5
_extractnet_init.outNet = Rpath + net + '_m1.asc'
_extractnet_init.process();
