-- selezione serie temporali
SELECT p.id id_stazione,p.nome,m.*
FROM metadati m, punti_monitoraggio p
WHERE m.tipologia_serie_temporali_id IN (2,6,8,10,13,15)
AND m.punti_monitoraggio_id IN (
	SELECT p.id
	FROM a_raintal a, punti_monitoraggio p
	WHERE ST_Intersects(a.the_geom, ST_Buffer(p.the_geom, 10000))
)
AND p.id=m.punti_monitoraggio_id
AND m.fine>=strftime('%s','2010-01-01 00:00:00')*1000 	
AND m.inizio<strftime('%s','2015-01-01 00:00:00')*1000
ORDER BY m.punti_monitoraggio_id


-- numero di serie temporali per tipologia
SELECT m.tipologia_serie_temporali_id,count(m.punti_monitoraggio_id) num_serie
FROM metadati m
WHERE m.tipologia_serie_temporali_id IN (2,6,8,10,13,15)
AND m.punti_monitoraggio_id IN (
	SELECT p.id
	FROM a_raintal a, punti_monitoraggio p
	WHERE ST_Intersects(a.the_geom, ST_Buffer(p.the_geom, 10000))
)
AND m.fine>=strftime('%s','2010-01-01 00:00:00')*1000 	
AND m.inizio<strftime('%s','2015-01-01 00:00:00')*1000
GROUP BY m.tipologia_serie_temporali_id

-- stazioni con serie disponibili e geometria 
SELECT p.id, p.nome, group_concat(m.id) serie_id, group_concat(m.tipologia_serie_temporali_id) tst_id, AsBinary(the_geom) the_geom
FROM metadati m, punti_monitoraggio p
WHERE m.tipologia_serie_temporali_id IN (2,6,8,10,13,15)
AND m.punti_monitoraggio_id IN (
	SELECT p.id
	FROM a_raintal a, punti_monitoraggio p
	WHERE ST_Intersects(a.the_geom, ST_Buffer(p.the_geom, 10000))
)
AND p.id=m.punti_monitoraggio_id
AND m.fine>=strftime('%s','2010-01-01 00:00:00')*1000 	
AND m.inizio<strftime('%s','2015-01-01 00:00:00')*1000
GROUP BY m.punti_monitoraggio_id

-- selezione dati precipitazione
SELECT m.punti_monitoraggio_id, s.metadati_id,strftime('%Y-%m-%d %H', s.dataora / 1000, 'unixepoch') || ":00" as dataora, round(sum(s.valore),1) as valore,s.affidabilita		
FROM serie_temporali s, metadati m
WHERE s.metadati_id IN ( 				
	SELECT m.id
	FROM metadati m, punti_monitoraggio p
	WHERE m.tipologia_serie_temporali_id=2
	AND m.punti_monitoraggio_id IN (
		SELECT p.id
		FROM a_raintal a, punti_monitoraggio p
		WHERE ST_Intersects(a.the_geom, ST_Buffer(p.the_geom, 10000))
	)
	AND p.id=m.punti_monitoraggio_id
	AND m.fine>=strftime('%s','2010-01-01 00:00:00')*1000 	
	AND m.inizio<strftime('%s','2015-01-01 00:00:00')*1000
)
AND s.dataora>=strftime('%s','2010-01-01 00:00:00')*1000  		
AND s.dataora<strftime('%s','2015-01-01 00:00:00')*1000
AND s.metadati_id=m.id
GROUP BY m.punti_monitoraggio_id, strftime('%Y-%m-%d %H', s.dataora / 1000, 'unixepoch') 


-- selezione dati temperatura, umidità, radiazione, neve
SELECT m.punti_monitoraggio_id, s.metadati_id,strftime('%Y-%m-%d %H', s.dataora / 1000, 'unixepoch') || ":00" as dataora, round(avg(s.valore),1) as valore,s.affidabilita		
FROM serie_temporali s, metadati m
WHERE s.metadati_id IN ( 				
	SELECT m.id
	FROM metadati m, punti_monitoraggio p
	WHERE m.tipologia_serie_temporali_id=8
	AND m.punti_monitoraggio_id IN (
		SELECT p.id
		FROM a_raintal a, punti_monitoraggio p
		WHERE ST_Intersects(a.the_geom, ST_Buffer(p.the_geom, 10000))
	)
	AND p.id=m.punti_monitoraggio_id
	AND m.fine>=strftime('%s','2010-01-01 00:00:00')*1000 	
	AND m.inizio<strftime('%s','2015-01-01 00:00:00')*1000
)
AND s.dataora>=strftime('%s','2010-01-01 00:00:00')*1000  		
AND s.dataora<strftime('%s','2015-01-01 00:00:00')*1000
AND s.metadati_id=m.id
GROUP BY m.punti_monitoraggio_id, strftime('%Y-%m-%d %H', s.dataora / 1000, 'unixepoch') 























































