function show_profile(I)

nlevs = size(I,3);

img = I(:,:,floor(nlevs/2)+1);

mimg = min(img(:)); % Get the min and the max of the image
Mimg = max(img(:)); % Usefull for the visualization

labels = cell(nlevs,1);
labels(floor(nlevs/2)+1) = {'$f$'};
for i=1:floor(nlevs/2)
    labels(i) = {['$\phi_', int2str(floor(nlevs/2)-i+1), '(f)$']};
    labels(floor(nlevs/2)+i+1) = {['$\gamma_', int2str(i), '(f)$']};
end

figure, % Show the complete profile
for i=1:nlevs
    subaxis(1, nlevs, i,'SpacingHoriz',0.005, 'MR', 0.01, 'ML', 0.01, 'MT', 0, 'MB', 0);
    imshow(I(:,:,i), [mimg Mimg])
    xlabel(labels{i}, 'FontSize', 15, 'Interpreter', 'latex')
end