function Ir = rescale_img(I, vmin, vmax)
% Rescale the values of every band of I within the range [vmin, vmax]

I = double(I);
Ir = zeros(size(I));
for i=1:size(I,3)
    bmin = min(min(I(:,:,i)));
    bmax = max(max(I(:,:,i)));
    Ir(:,:,i) = (vmax-vmin) * (I(:,:,i) - bmin) / (bmax-bmin) + vmin;
end