function imshow_stretch(I, stretchval)
% Show a grayscale or RGB image after performing a stretching of its
% dynamic

if nargin<2
    stretchval = 0.1;
end

nbins = 1000;
tol_low = stretchval;
tol_high = 1-stretchval;

I = double(I);
Iadj = zeros(size(I));
for i=1:size(I,3)
    tmp = I(:,:,i);
    tmp = tmp - min(tmp(:));
    tmp = tmp / max(tmp(:));
    
    N = hist(tmp(:),nbins);
    cdf = cumsum(N)/sum(N); %cumulative distribution function
    ilow = find(cdf > tol_low, 1, 'first');
    ihigh = find(cdf >= tol_high, 1, 'first');
    
    ilow = (ilow - 1)/(nbins-1);
    ihigh = (ihigh - 1)/(nbins-1);
    
    li = ilow;
    lo = 0;
    hi = ihigh;
    ho = 255;
    out = (tmp < li) .* lo;
    out = out + (tmp >= li & tmp < hi) .* (lo + (ho - lo) .* ((tmp - li) / (hi - li)));
    out = out + (tmp >= hi) .* ho;
    
    Iadj(:,:,i) = out;
end

imshow(uint8(Iadj))

% In matlab do: imshow(imadjust(I,stretchlim(I, stretchval)));