% WHISPERS 2014
% Tutorial: Image analysis of hyperspectral data using mathematical morphology
% Mauro DALLA MURA and Mathieu FAUVEL
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr, mathieu.fauvel@ensat.fr}

% Tutorial Part III

% Classification
clear
close all
clc

%% Spectral Classification
init
init_classif

%% DO THE PART ON VISUALIZATION AND EXPLORATORY ANALYSIS

%% Plot some statistical information
% compute correlation matrix
Cm = corr(data_vec(1:100:end,:));
imagesc(Cm)
colorbar

% compute std of each band
sigma = std(data_vec);
figure
plot(sigma)


%% Dimensionality reduction
%% Principal component analysis
Sigma = cov(data_vec);
[V D] = eig(Sigma); % Compute the eigenvalues/eigenvectors 
[D,ind] = sort(diag(D),'descend');
V = V(:,ind);

figure,
plot(cumsum(D)/sum(D),'LineWidth',3);grid on; % Plot the cummulative eigenvalue
% Keep d eigenvalues to reconstruct DR% of the cummulative variance
DR = 0.95;
d_pca=find((cumsum(D)/sum(D))>DR,1); % 
Dp = data_vec*V(:,1:d_pca);% Projet the data on the d first eigenvector

% Plot the first eigenvectors
figure, 
for i=1:size(Dp,2)
    imshow(reshape(Dp(:,i), nr, nc),[]), pause(0.5)
end

%% Linear Discriminant Aanalyis

% Generate train and test sets 
number_training_pixels_per_classe = 40;
[tr_idx, ts_idx] = gen_train_test(test, number_training_pixels_per_classe);


[V, D]=afd(data_vec(tr_idx,:),test(tr_idx));
% [v, e]=afd(data_vec(ts_idx,:),test(ts_idx));
figure,
plot(cumsum(D)/sum(D))
d_lda=find((cumsum(D)/sum(D))>DR,1); % 
Dlda = data_vec*V(:,1:d_lda);
figure, 
for i=1:size(Dlda,2)
    imshow(reshape(Dlda(:,i), nr, nc),[]), pause(0.5)
end

%% Spectral classification


%%
% Classify data
L = svm_class(data_vec, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA data: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)


%%
% Classify a single band
band = 1;
% band = 80;
L = svm_class(data_vec(:,band), test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA band %d: %f\n', band, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

% Classify a true color composition
L = svm_class(data_vec(:,[36, 28, 1]), test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA true color: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)


% Classify a false color composition
L = svm_class(data_vec(:,[80, 36, 28]), test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA false color: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

% Classify the PCs
L = svm_class(Dp, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA %d PCs: %f\n', d_pca, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

% Classify the LDA components
L = svm_class(Dlda, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA %d LDA components: %f\n', d_lda, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% Spatial features

disp('*** Profiles on PCA\n');

%% Compute a EMP with geodesic reconstruction
dorec = 1;
EMP = morphological_profile(reshape(Dp, nr, nc, d_pca), [3 5 7 9], 'disk', dorec);
EMP_vec = reshape(EMP, nr*nc, size(EMP,3));

% Classification step
L = svm_class(EMP_vec, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% Compute a EMP without reconstruction
dorec = 0;
EMP = morphological_profile(reshape(Dp, nr, nc, d_pca), [3 5 7 9], 'disk', dorec);
EMP_vec = reshape(EMP, nr*nc, size(EMP,3));

% Classification step
L = svm_class(EMP_vec, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)


%% Compute EAP

%% EAP area
attr = 'area';
lambdas = [100 500 1000 5000];
EAP = ext_attribute_profile(reshape(Dp, nr, nc, d_pca), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_a = double(reshape(EAP, nr*nc, size(EAP,3)));

%%
L = svm_class(EAP_a, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EAP inertia
attr = 'inertia';
lambdas = [0.2 0.3 0.4 0.5];
EAP = ext_attribute_profile(reshape(Dp, nr, nc, d_pca), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_i = double(reshape(EAP, nr*nc, size(EAP,3)));

%%
L = svm_class(EAP_i, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EAP std
attr = 'std';
lambdas = [20 30 40 50];
EAP = ext_attribute_profile(reshape(Dp, nr, nc, d_pca), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_s = double(reshape(EAP, nr*nc, size(EAP,3)));

%% 
L = svm_class(EAP_s, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EMAP
EMAP = [EAP_a, EAP_i, EAP_s];

L = svm_class(EMAP, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMAP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%%
disp('*** Profiles on LDA\n');

%% Compute a EMP with geodesic reconstruction
dorec = 1;
EMP = morphological_profile(reshape(Dlda, nr, nc, d_lda), [3 5 7 9], 'disk', dorec);
EMP_vec = reshape(EMP, nr*nc, size(EMP,3));

%%
L = svm_class(EMP_vec, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% Compute a EMP without reconstruction
dorec=0;
EMP = morphological_profile(reshape(Dlda, nr, nc, d_lda), [3 5 7 9], 'disk', dorec);
EMP_vec = reshape(EMP, nr*nc, size(EMP,3));

%%
L = svm_class(EMP_vec, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% Compute EAP

%% EAP area
attr = 'area';
lambdas = [100 500 1000 5000];
EAP = ext_attribute_profile(reshape(Dlda, nr, nc, d_lda), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_a = double(reshape(EAP, nr*nc, size(EAP,3)));

%%
L = svm_class(EAP_a, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EAP inertia
attr = 'inertia';
lambdas = [0.2 0.3 0.4 0.5];
EAP = ext_attribute_profile(reshape(Dlda, nr, nc, d_lda), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_i = double(reshape(EAP, nr*nc, size(EAP,3)));

%%
L = svm_class(EAP_i, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EAP std
attr = 'std';
lambdas = [20 30 40 50];
EAP = ext_attribute_profile(reshape(Dlda, nr, nc, d_lda), attr, lambdas);

figure,
for i=1:size(EAP,3)
    imshow(EAP(:,:,i),[]), 
    pause(.1), 
end
EAP_s = double(reshape(EAP, nr*nc, size(EAP,3)));

%% 
L = svm_class(EAP_s, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EAP %s: %f\n', attr, acc);
figure, imshow(reshape(L,nr,nc), class_cmap)

%% EMAP
EMAP = [EAP_a, EAP_i, EAP_s];

L = svm_class(EMAP, test, tr_idx);
acc = sum(L(ts_idx) == test(ts_idx)) / length(ts_idx);
fprintf('OA EMAP: %f\n', acc);
figure, imshow(reshape(L,nr,nc), class_cmap)




