% WHISPERS 2014
% Tutorial: Image analysis of hyperspectral data using mathematical morphology
% Mauro DALLA MURA and Mathieu FAUVEL
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr, mathieu.fauvel@ensat.fr}

% Tutorial Part I

clear
close all
clc

%%
init

%% Basic MM operators 
img = imread('cameraman.tif');
se = strel('disk', 3);% Define the structuring element
                      % Here a disk of radius 3
                      % Other SEs are possible, with different sizes
                      % More information: 'doc strel'

figure, imshow(imerode(img, se))        % Erosion
figure, imshow(imdilate(img, se))       % Dilation
figure, imshow(imopen(img, se))         % Opening: Erosion + Dilation
figure, imshow(imclose(img, se))        % Closing: Dilation + Erosion
figure, imshow(imopenbyrec(img, se))    % Opening by reconstruction
figure, imshow(imclosebyrec(img, se))   % Closing by reconstruction
clear se

% Do a comparison with what is obtained by a linear filter
h = fspecial('gaussian', 5);
figure, imshow(imfilter(img, h))        % Gaussian filter

%% A closer look to geodesic reconstruction
img1 = imread('sample_af.png'); % Load toy data set
se = strel('disk', 20);
figure, imshow(img1)
figure, imshow(imopen(img1, se))
figure, imshow(imopenbyrec(img1, se))
clear img1 se 

%% Create a MP
mimg = min(img(:)); % Get the min and the max of the image
Mimg = max(img(:)); % Usefull for the visualization
MP = morphological_profile(img, [3 9 15 25], 'disk', 1); 
figure, % Show each closing/opening by reconstruction
for i=1:size(MP,3)
  imshow(MP(:,:,i), [mimg Mimg])
  pause(.25)
end

figure, % Show the complete profile
show_profile(MP)

%% Differential Morphological Profile
DMP = diff(MP,1,3); % MP[:,:,i+1]-MP[:,:,i]
figure,
for i=1:size(DMP,3)
  imshow(DMP(:,:,i), [])
  pause(.25)
end

figure,
for i=1:size(DMP,3)
    subplot(1, size(DMP,3), i)
    imshow(DMP(:,:,i),[])
end

clear DMP MP mimg Mimg img
%% Processing of color images
% img = imread('color.png'); % Load color image
img = imread('baboon.jpg'); % Load color image

% Marginal ordering 
img_Mord = img; % Initialization of the output for marginal ordering
se = strel('disk', 10);

figure,
for i=1:3
    img_Mord(:,:,i) = imdilate(img(:,:,i), se);
    subplot(1, 3, i)
    imshow(img_Mord(:,:,i),[])
end
figure, imshow(img_Mord)

figure,
for i=1:3
    img_Mord(:,:,i) = imerode(img(:,:,i), se);
    subplot(1, 3, i)
    imshow(img_Mord(:,:,i),[])
end
figure, imshow(img_Mord)

%%
% Reduced ordering
img_hsv = rgb2hsv(img); % Transformation of the RGB image into HSV colorspace
img_Rord = img_hsv;

img_Rord(:,:,3) = imdilate(img_Rord(:,:,3), se); 
figure, imshow(img_Rord(:,:,3),[])
img_Rord = hsv2rgb(img_Rord);
figure, imshow(img_Rord)

img_Rord = img_hsv;
img_Rord(:,:,3) = imerode(img_Rord(:,:,3), se);
figure, imshow(img_Rord(:,:,3),[])
img_Rord = hsv2rgb(img_Rord);
figure, imshow(img_Rord)

%% Do the same on a remote sensign image
clear
close all
clc

I = imread('pavia.png');
