function MP = morphological_profile(I, sizes, shape, dorec, strel_opt)

% Parse inputs
if nargin < 5
    strel_opt = [];
end
if nargin < 4
    dorec = 1;
end
if nargin < 3
    shape = 'disk';
end
if nargin < 2
    sizes = [3 5 7 9];
end

MP = [];
if size(I,3) > 1
    for i=1:size(I,3)
        mp_i = morphological_profile(I(:,:,i), sizes, shape, dorec);
        MP = cat(3, MP, mp_i);
    end
    return;
end


% Define the SEs
nse = length(sizes);
for i=1:nse
    if isempty(strel_opt)
        se(i) = strel(shape, sizes(i));
    else
        se(i) = strel(shape, sizes(i), strel_opt);
    end
end


%% Create the MP
MP = zeros([size(I), 2*nse+1]);

% Closing profile
for i=1:nse
    if dorec
        MP(:,:,i) = imclosebyrec(I, se(nse-i+1));
    else
        MP(:,:,i) = imclose(I, se(nse-i+1));
    end
end
% Original image = open(I,0) = close (I,0)
MP(:,:,nse+1) = I;

% Opening profile
for i=1:nse
    if dorec
        MP(:,:,nse+1+i) = imopenbyrec(I, se(i));
    else
        MP(:,:,nse+1+i) = imopen(I, se(i));
    end
end

