function R = imrecbyero(f, g, varargin)
%IMRECBYERO Morphological geodesic reconstruction by erosion.
%
%   R = IMRECBYERO(f, g)
%   R = IMRECBYERO(f, g, c)
%
% Inputs
%   f   Grayscale or binary image
%   g   Mask image (default the original image)
%   c   Connectivity (using defaults of imreconstruct)
%
% Output
%   R  Grayscale or binary image with the result of the processing
%
% Definition
% Geodesic reconstruction by erosion of the image f by the mask g using
% connectivity c (for defining the SE of the elementary erosion). This
% function is based on imreconstruct.

% Mauro Dalla Mura
% GIPSA-lab, Grenoble-INP
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr
% Created 08 Apr 2014

R = imcomplement(imreconstruct(imcomplement(f),imcomplement(g), varargin{:}));