function R = imrecbydil(varargin)
%IMRECBYDIL Morphological geodesic reconstruction by dilation.
%
%   R = IMRECBYDIL(f, g)
%   R = IMRECBYDIL(f, g, c)
%
% Inputs
%   f   Grayscale or binary image
%   g   Mask image (default the original image)
%   c   Connectivity (using defaults of imreconstruct)
%
% Output
%   R  Grayscale or binary image with the result of the processing
%
% Definition
% Geodesic reconstruction by dilation of the image f by the mask g using
% connectivity c (for defining the SE of the elementary dilation). This
% function is just a wrapper on Matlab builtin imreconstruct.

% Mauro Dalla Mura
% GIPSA-lab, Grenoble-INP
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr
% Created 08 Apr 2014

R = imreconstruct(varargin{:});
