function gamma = imopenbyrec(f, b, g, varargin)
%IMOPENBYREC Morphological opening by reconstruction.
%
%   gamma = IMOPENBYREC(f, b)
%   gamma = IMOPENBYREC(f, b, g)
%   gamma = IMOPENBYREC(f, b, g, c)
%
% Inputs
%   f   Grayscale or binary image
%   b   Structuring element (instance of class strel)
%   g   Mask image (default the original image)
%   c   Connectivity (using defaults of imreconstruct)
%
% Output
%   gamma  Grayscale or binary image with the result of the processing
%
% Definition
% Opening by reconstruction. Geodesic reconstruction by dilation of the
% erosion of the input image using the original image as mask.

% Mauro Dalla Mura
% GIPSA-lab, Grenoble-INP
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr
% Created 08 Apr 2014

if nargin < 3
    g = f;
end

gamma = imrecbydil(imerode(f, b), g, varargin{:});
% gamma = imreconstruct(imerode(f, b), g);
