function phi = imclosebyrec(f, b, g, varargin)
%IMCLOSEBYREC Morphological closing by reconstruction.
%
%   phi = IMCLOSEBYREC(f, b)
%   phi = IMCLOSEBYREC(f, b, g)
%   phi = IMCLOSEBYREC(f, b, g, c)
%
% Inputs
%   f   Grayscale or binary image
%   b   Structuring element (instance of class strel)
%   g   Mask image (default the original image)
%   c   Connectivity (using defaults of imreconstruct)
%
% Output
%   phi  Grayscale or binary image with the result of the processing
%
% Definition
% Closing by reconstruction. Geodesic reconstruction by erosion of the
% dilation of the input image using the original image as mask.

% Mauro Dalla Mura
% GIPSA-lab, Grenoble-INP
% mauro.dalla-mura@gipsa-lab.grenoble-inp.fr
% Created 08 Apr 2014

if nargin < 3
    g = f;
end

phi = imrecbyero(imdilate(f, b), g, varargin{:});
% phi = imcomplement(imreconstruct(imerode(imcomplement(f),b),imcomplement(g), varargin{:}));