function MP = directional_profile(I, sizes, angles, dorec)

% Parse inputs
if nargin < 4
    dorec = 1;
end
if nargin < 3
    angles = [0 45 90 135];
end
if nargin < 2
    sizes = [3 5 7 9];
end

MP = [];
if size(I,3) > 1
    for i=1:size(I,3)
        mp_i = directional_profile(I(:,:,i), sizes, angles, dorec);
        MP = cat(3, MP, mp_i);
    end
    return;
end

nse = length(sizes);
MP = cat(3,cat(3,max(I(:))*ones([size(I), nse]), I), min(I(:))*ones([size(I), nse]));

for j=1:length(angles)
    % Define the SEs
    for i=1:nse
        se(i) = strel('line', sizes(i), angles(j));
    end
    
    
    %% Create the MP
    
    % Closing profile
    for i=1:nse
        if dorec
            MP(:,:,i) = min(imclosebyrec(I, se(nse-i+1)), MP(:,:,i));
        else
            MP(:,:,i) = min(imclose(I, se(nse-i+1)), MP(:,:,i));
        end
    end
    % Original image = open(I,0) = close (I,0)
    % MP(:,:,nse+1) = I;
    
    % Opening profile
    for i=1:nse
        if dorec
            MP(:,:,nse+1+i) = max(imopenbyrec(I, se(i)), MP(:,:,nse+1+i));
        else
            MP(:,:,nse+1+i) = max(imopen(I, se(i)), MP(:,:,nse+1+i));
        end
    end
end

