function [kx] = kernel_pca(x,nkpc)
% Compute the kernel PCA with the Gaussian Kernel
% Input :
%   x: the data
%   nkpc: the number of extracted KPCA
% Rescale data to the interval [-1, 1]
xm = min(x);
xM = max(x);
x = 2*bsxfun(@minus,x,xm);
x = bsxfun(@times,x,1./(xM-xm))-1;

NS = 10000; % Number of randomly selected samples
% Get the dimension of the data
[n,d] = size(x);
t = randperm(n);
X = x(t(1:NS),:);

% Compute the kernel matrix
D = triu(sqrt(sq_dist(X',X')),1);
sig = mean(D(D>0)); % Estim the paramter sig as the mean value of the
                    % distance between each samples
clear D
K = exp(-0.5*sq_dist(X',X')/sig^2); K=(K+K')/2; % Make it DSP
Kc = centering(K); %center the kernel matrix

[V, E] = eigs(Kc, nkpc);
E = diag(E);
fprintf('Extract %d KPC ~ %f %% of the cummulative variance\n',nkpc,sum(E)/sum(diag(Kc))*100)
for i=1:nkpc % Normalize kpc
    V(:,i)=V(:,i)/sqrt(E(i));
end
clear Kc
% Projection
kx = zeros(n,nkpc);
for i=1:10000:n % here the number "10000" can be changed, it depends on the available RAM 
  if(i+10000 < n)
    Kt = compute_kernel(x(i:i+10000,:),X,sig);
    Kt = centering(Kt,K);
    kx(i:i+10000,:)=Kt *V;
    clear Kt
  else
    Kt=compute_kernel(x(i:n,:),X,sig);
    Kt = centering(Kt,K);
    kx(i:n,:)=Kt*V;
    clear kt
  end    
end

function  K =compute_kernel(X,Y,sigma)
%--------------------------------------
% function  K =compute_kernel(X,Ysigma);
% the function compute the kernel matrix with a RBF kernel
% K the kernel matrix
%--------------------------------------

K = exp(-0.5 * sq_dist(X',Y')/sigma^2);

function Kc=centering(K,K_old)
% Function that center the kernel matrix
if nargin ==1
    n = size(K,1);
    s = sum(K(:))/n^2;
    ks = sum(K,2)/n;
    Kc = bsxfun(@minus,K,ks);
    Kc = bsxfun(@minus,Kc,ks')+s;
else
    n = size(K_old,1);
    s = sum(K_old(:))/n^2;
    ks = sum(K_old,1)/n;
    kz = sum(K,2)/n;
    Kc = bsxfun(@minus,K,kz);clear kz
    Kc = bsxfun(@minus,Kc,ks)+s;clear ks
end
