function [v e]=afd(x,y)
% Compute the discriminant analysis feature extraction
% From Landgrebe, "Signal theory methods in multispectral remote sensing"
% Input: 
%   x: the sample matrix
%   y: the class
% Output:
%   v: the discriminant vector
%   e: the eigenvalue

% Compute some parameters
[n,d]=size(x);
C = max(y);

mu = zeros(C,d);
Sig = zeros(C,d,d);
prop = zeros(C,1);
mu0 = zeros(1,d);
% Compute the statistical parameter
for i=1:C
    t = find(y==i);
    xi = x(t,:);
    prop(i)=length(t)/n;
    mu(i,:)=mean(xi);
    mu0 = mu0 + prop(i)*mu(i,:);
    Sig(i,:,:)=cov(xi);
end

% Compute the within/between class matrix
Sw = zeros(d);
Sb = zeros(d);
for i=1:C
    Sw=Sw + prop(i)*squeeze(Sig(i,:,:));
    Sb=Sb + prop(i)*(mu(i,:)-mu0)'*(mu(i,:)-mu0);
end
Sw = Sw +eye(d)*0.00001;
Sb = Sb +eye(d)*0.00001;
[v,e]=eigs(Sb,Sw,C-1); % Only compute the C-1 first eigenvectors
e=diag(e);
