function L = svm_class(D, lab, tr_idx)

% Rescale data to the interval [-1, 1]
Dm = min(D);
DM = max(D);
Df = DM-Dm;
Df(Df==0)=1;
D = 2*bsxfun(@minus,D,Dm);
D = bsxfun(@times,D,1./Df)-1;

% Cross-Validation  step
g=2.^(-4:1:8);
for i=1:length(g)
    svm_opt=sprintf('-c 100 -g %f -v 5 -q',g(i));
    cv(i)=svmtrain(lab(tr_idx), D(tr_idx,:),svm_opt);
end
[~,i]=max(cv);

% SVM Options
svm_opt = sprintf('-c 100 -q -g %f',g(i));

% Training
mod = svmtrain(lab(tr_idx), D(tr_idx,:), svm_opt);

% Prediction
L = svmpredict(ones(size(D,1),1), D, mod, '-q');
