function [tr_idx, ts_idx] = gen_train_test(L, nsamples)
% function generating a training and a test set from the labelled set of
% samples L (typically an image with labelled pixels set to values greater
% than zero and correspondent to their class index).
% Warning! It is assumed that the given number of samples is not less than
% the minimum available number of labelled samples for each class.

if nargin < 2
    nsamples = 10;
end

labels = unique(L(:));
labels = labels(labels>0);  % label 0 means unclassified so remove it
nclasses = length(labels);

% generate a random set of labelled samples used for training
tr_idx = zeros(nsamples*nclasses,1);
for i=1:nclasses
    idx = find(L==labels(i));
    idx = idx(randperm(length(idx)));
    tr_idx((i-1)*nsamples+1:i*nsamples) = idx(1:nsamples);
end

% remove samples used for training from the test
test = double(L);
ts = test;
ts(tr_idx) = 0;
ts_idx = find(ts>0);