#! /usr/bin/env python

from __future__ import print_function, division, absolute_import
import numpy as np
import matplotlib.pyplot as plt
import matplotlib

rsat = np.genfromtxt('fig4_b.dat')
delta = np.linspace(0.01,0.40,40)
gamexp = np.linspace(-8,-1,50)
plt.pcolormesh(gamexp,delta,rsat,cmap='Blues')
plt.colorbar()
matplotlib.rcParams['contour.negative_linestyle'] = 'solid'
CS = plt.contour(gamexp, delta, rsat, levels=np.arange(-3,10,2), colors='black', zorder=1)
plt.clabel(CS, inline=1, fontsize=12, fmt='%1.1f')
plt.title(r'$\mathrm{log10}\;\rho(T\rightarrow 0)$', fontsize=16)
plt.xlabel(r'$\mathrm{log10}\;\Gamma$', fontsize=14)
plt.ylabel(r'$\Delta\;[\mathrm{eV}]$', fontsize=14)
plt.show()

tstar = np.genfromtxt('fig4_c.dat')
delta = np.linspace(0.01,0.40,40)
gamexp = np.linspace(-8,-1,50)
plt.pcolormesh(gamexp,delta,tstar,cmap='Blues')
plt.colorbar()
levels = [5,10,20,30,40,50,75,100,150,300]
CS = plt.contour(gamexp, delta, tstar, levels=levels, colors='black', zorder=2)
plt.clabel(CS, inline=1, fontsize=12, fmt='%1.0f')
plt.title(r'$T*\;[\mathrm{K}]$', fontsize=16)
plt.xlabel(r'$\mathrm{log10}\;\Gamma$', fontsize=14)
plt.ylabel(r'$\Delta\;[\mathrm{eV}]$', fontsize=14)
plt.show()
