#! /usr/bin/env python

from __future__ import print_function, division, absolute_import
import numpy as np
import matplotlib.pyplot as plt

for delta,gam,color in zip(['0.1','0.1','0.1','0.2','0.3'],['-6','-5','-4','-4','-4'], \
                           ['blue','green','red','red','red']):
  data = np.genfromtxt('fig4_a_delta{}_gamma1e{}.dat'.format(delta,gam))
  plt.plot(data[:,0],data[:,1],color=color,lw=2)
data = np.genfromtxt('fig4_a_boltz.dat')
plt.plot(data[:,0],data[:,1],color='black',lw=2,ls='--')
plt.yscale('log')
plt.xscale('log')
plt.ylim(2e-8,1e6)
plt.xlabel(r'$T\;[\mathrm{K}]$', fontsize=14)
plt.ylabel(r'$\rho\;[\Omega\mathrm{m}]$', fontsize=14)
plt.show()

