import ndim
import numpy

from ..helpers import QuadratureScheme


class UnScheme(QuadratureScheme):
    def __init__(self, name, dim, weights, points, degree, source, tol=1.0e-14):
        super().__init__(name, weights, points, degree, source, tol)
        self.domain = f"Un (n={dim})"
        self.dim = dim

    def integrate(self, f, center, radius, dot=numpy.dot):
        center = numpy.array(center)
        rr = numpy.multiply.outer(radius, self.points)
        rr = numpy.swapaxes(rr, 0, -2)
        ff = numpy.array(f((rr + center).T))
        ref_vol = ndim.nsphere.volume(self.dim, r=radius)
        return ref_vol * dot(ff, self.weights)
