import pathlib

from ...helpers import article
from .._classical import face_midpoint as witherden_vincent_03
from .._classical import midpoint as witherden_vincent_01
from .._hammer_stroud import hammer_stroud_4_3 as witherden_vincent_05
from .._helpers import C3Scheme, register

_source = article(
    authors=["F.D. Witherden", "P.E. Vincent"],
    title="On the identification of symmetric quadrature rules for finite element methods",
    journal="Computers & Mathematics with Applications",
    volume="69",
    number="10",
    month="may",
    year="2015",
    pages="1232–1241",
    url="https://doi.org/10.1016/j.camwa.2015.03.017",
)

this_dir = pathlib.Path(__file__).resolve().parent


def witherden_vincent_07():
    d = {
        "symm_r00": [
            [0.20012989098356700695575850638756794678 / 8],
            [0.98808616118867654860459729594655654482],
        ],
        "symm_rr0": [
            [0.15930172375100887182052758490800036662 / 8],
            [0.84805227568403872779622085759407839383],
        ],
        "symm_rrr": [
            [
                0.45715385606985274296912190785204854361 / 8,
                0.15379614006595869408326783499527494637 / 8,
            ],
            [
                0.40795516735831936633080916251520586856,
                0.78110282100411850665136814715928740203,
            ],
        ],
    }
    return C3Scheme("Witherden-Vincent 7", d, 7, _source)


def witherden_vincent_09():
    d = {
        "symm_r00": [
            [0.43327499574965454300983079319432200813 / 8],
            [0.61368146959170899383488488974055688452],
        ],
        "symm_rr0": [
            [0.091789806136177642171244588919646331302 / 8],
            [0.87768712325767828648677575899433236264],
        ],
        "symm_rrr": [
            [
                0.050148795299349029867451487724661687604 / 8,
                0.19885983814402350032086871858560920797 / 8,
            ],
            [
                0.87009978466197591761506380886392483306,
                0.56411080702003005426661899866307283066,
            ],
        ],
        "symm_rrs": [
            [0.09611680351337336643247993847150603379 / 8],
            [0.43226790263086216441602486151694383909],
            [0.93853042186467174532897686960307879508],
        ],
    }
    return C3Scheme("Witherden-Vincent 9", d, 9, _source)


def witherden_vincent_11():
    d = {
        "symm_r00": [
            [0.2024770736128001905853371309670196589 / 8],
            [0.81261433409962649639237559737974432611],
        ],
        "symm_rr0": [
            [0.14519934586011569829250580079425982305 / 8],
            [0.73466828699700801734638476986754918792],
        ],
        "symm_rrr": [
            [
                0.11753834795645628038993180401068212711 / 8,
                0.044643912078829241641001154282130043664 / 8,
                0.21599204525496912931346666638444131361 / 8,
            ],
            [
                0.60167526419826270163441300578531749659,
                0.85545576101775998467509147069034657598,
                0.31339340451605472104577323055795129941,
            ],
        ],
        "symm_rrs": [
            [
                0.061441994097835335202750044633046200824 / 8,
                0.022614296138821884223196230668984478131 / 8,
            ],
            [
                0.45079993511450943037788434573026952398,
                0.94124485721060326391115015763113464139,
            ],
            [
                0.96509966551271026293028182312534456821,
                0.35390281459663013491031287081289167626,
            ],
        ],
    }
    return C3Scheme("Witherden-Vincent 11", d, 11, _source)


register(
    [
        witherden_vincent_01,
        witherden_vincent_03,
        witherden_vincent_05,
        witherden_vincent_07,
        witherden_vincent_09,
        witherden_vincent_11,
    ]
)
