# What is Kedro?

Kedro is an open-source Python framework for creating reproducible, maintainable and modular data science code. It
 borrows concepts from software engineering and applies them to machine-learning code; applied concepts include
  modularity, separation of concerns and versioning.

For the source code, take a look at the [Kedro repository on Github](https://github.com/quantumblacklabs/kedro).

## Learn how to use Kedro

In the next few chapters, you will learn how to [install Kedro](../02_get_started/01_prerequisites.md) and set up your own production-ready data pipelines.

Once you are set up, we suggest working through our examples, including:

- A typical "Hello World" example, for an [entry-level description of the main Kedro concepts](https://kedro.readthedocs.io/en/stable/02_get_started/03_hello_kedro.html)
- An [introduction to the product template](https://kedro.readthedocs.io/en/stable/02_get_started/05_example_project.html) using the Iris dataset
- A more detailed [spaceflights tutorial](https://kedro.readthedocs.io/en/stable/03_tutorial/02_tutorial_template.html) to give you hands-on experience

We also recommend the [frequently asked questions](../12_faq/01_faq.md) and the [API reference documentation](/kedro.rst) for additional information.

## Assumptions

We have designed the documentation and the [spaceflights tutorial](../03_tutorial/01_spaceflights_tutorial.md) for anyone new to Kedro. The more knowledge of Python you have, the easier you will find the learning curve.

> *Note:* There are a number of excellent online resources for learning Python, but you should choose those that reference Python 3, as Kedro is built for Python 3.6+. There are many curated lists of online resources, such as:
>
> -   [Official Python programming language website](https://www.python.org/)
> -   [List of free programming books and tutorials](https://github.com/EbookFoundation/free-programming-books/blob/master/free-programming-books.md#python)
