********************************************************************************************
***DISCERN/ ASHISH ARORA, SHARON BELENZON, LIA SHEER (DUKE UNIVERSITY) / DECEMBER 2020***
********************************************************************************************
********************************************************************************************
*Compiling Patent data: flow+stock variables including dynamic reassignment of patents 
*Data: U.S. granted patents from USPTO 1980-2015
*INPUT FILE: Match file of UO & Subsidiary Patents- linking id_name to patents: "patent_match_id_name.dta"
*OUTPUT FILES:
*patent stock w/ reassignment: pat_stock_permno_adj.dta
*patent flow: pat_per_year_permno_adj.dta
*Aggregate permno_adj-year level patent data are available in the main panel file
*the main patent dataset is also compiled here but is finalized at the last part of "./programs/panel_do.do"
******************************************************************************************************************
*******************************************************************************************************************
********************************************************************************************************************
********************************************************************************************************************
**********RELEVANT PERMNO_ADJ AT PATENT GRANT YEAR*******************
*Dynamic list UO and Subsidiary
use "./data/DISCERN_UO_name_list.dta", clear
append using "./data/DISCERN_SUB_name_list.dta"
keep sample id_name fyear* nyear* permno_adj*
label var sample "U=UO+Labs+traded-Subs//A=ORBIS Subs//B=Pre-2002 manual Subs//C=NBER2006"
save "./data/dyn_match_All.dta", replace
*********************************************************************
use "./data/patent_match_id_name.dta"  , clear
merge m:m id_name sample using "./data/dyn_match_All.dta"
keep if _m==3
drop _m
ren publn_year year
* appropriate permno_adj to assign the patents at grant year
gen permno_adj=.
forvalue i=0/5 {
replace permno_adj = permno_adj`i' if permno_adj`i'~=. & year>=fyear`i' & year<=nyear`i'
}

*Patents enter our sample once the related UO firm is publicly traded and not before. 
*Furthermore, we do not account for patents in gap years when the related UO firm is not publicly traded.
drop if permno_adj==.
ren year  publn_year 
label var permno_adj "UO firm at the time patent was granted"
label var publn_nr "Patent number"
label var name_std "std name matched"
label var id_name "id name_std matched"
label var sample "A:ORBIS-Subs;B:PRE2002Subs;C:NBER2006;U:UO-match"
label var id_name1 "id_name#sample"
label var publn_year "patent grant year"
save "./data/patent_1980_2015.dta", replace
**this is an intermediate file - the main patent dataset is finalized at the last part of "./programs/panel_do.do"
****************************************************************************
***********COMPUTING PATENT STOCK - similar to NBER2006 code***************
use "./data/patent_1980_2015.dta"  , clear
drop permno_adj
duplicates drop

sort publn_nr
*count number of assignees for each patent
by publn_nr: egen nass = count(id_name1)

*calculate fractional patent ownership
gen npat = 1 / nass

*gen NPAT, for each ID_NAME-YEAR
sort id_name1 publn_year
by id_name1 publn_year: egen npat_id_name_gyear=sum(npat)

save "./data/patent_database", replace

use "./data/patent_database", clear
duplicates drop id_name1  publn_year, force
keep id_name1 publn_year npat_id_name_gyear
ren publn_year year
*name level pat count
fillin id_name1 year
replace npat_id_name_gyear=0 if npat_id_name_gyear==.

gen id_name=substr(id_name1, 2,.)
gen sample=substr(id_name1, 1,1)
destring id_name, replace

*Dynamic match of assignee to UO firms
merge m:m id_name sample using "./data/dyn_match_All.dta"
keep if _m==3
drop _m

*Appropriate permno_adj to assign the patents in each year

gen permno_adj=.

forvalue i=0/5 {
replace permno_adj = permno_adj`i' if permno_adj`i'~=. & year>=fyear`i' & year<=nyear`i'
}

*Patents enter our sample once the related UO firm is publicly traded and not before
drop if fyear0!=. & year<fyear0
drop if fyear0==.& year<fyear1

*Generating patent stock - 0.15% growth per year plus 15% depreciation
gen sum_npat_id_name=npat_id_name_gyear/0.15
sort id_name1 year
by id_name1: replace sum_npat_id_name=0.85*sum_npat_id_name[_n-1]+npat_id_name_gyear if sum_npat_id_name[_n-1]!=.

keep year id_name1 id_name npat_id_name_gyear _fillin sum_npat_id_name  permno_adj  sample
save "./data/id_name_year_npat", replace

*sum over multiple names to get patents for each permno_adj 
use "./data/id_name_year_npat", clear
drop if permno_adj==.
sort id_name1 year
collapse (sum) sum_npat_id_name,by(permno_adj year)
ren sum_npat_id_name pat_stock_permno_adj
label var pat_stock_permno_adj "Cumulative patent count-including reassignment"
label var permno_adj "UO firm at focal year"
save "./data/pat_stock_permno_adj", replace
*******************************************************************************************
*Patent firms- with positive patent stock

use "./data/pat_stock_permno_adj", clear
drop if pat_stock_permno_adj==0
keep permno_adj
duplicates drop
save "./data/patent_firms.dta" , replace

**************************COMPUTING PATENTS GRANTED PER YEAR***********************************
use "./data/patent_database", clear
duplicates drop id_name1 publn_year, force
keep id_name1 id_name publn_year npat_id_name_gyear sample
ren publn_year year

merge m:m id_name sample using "./data/dyn_match_All.dta"
keep if _m==3
drop _m

* appropriate permno_adj to assign the patents in each year
gen permno_adj=.
forvalue i=0/5 {
replace permno_adj = permno_adj`i' if permno_adj`i'~=. & year>=fyear`i' & year<=nyear`i'
}
keep if permno_adj~=.
keep permno_adj year npat_id_name_gyear

* sum over multiple id_name to get patents for each permno_adj-year
sort permno_adj year
collapse (sum) npat_id_name_gyear,by(permno_adj year)

fillin permno_adj year
replace npat_id_name_gyear=0 if npat_id_name_gyear==.

ren npat_id_name_gyear pat_yr
drop _fillin
label var pat_yr "granted patents per permno_adj-year"
label var permno_adj "UO firm at the time patent was granted"
save "./data/pat_per_year_permno_adj", replace
************************************************************************************************************
**Merging Additional Patent Info to "patent_1980_2015.dta": ****************************
*THIS IS NOT PROVIDED- users should obtain the patent data for each patent and compile by themselves
*we compiled and merged variables such as: forward cites, backward cites, IPC, backward NPL cites ****
