********************************************************************************************
***DISCERN/ ASHISH ARORA, SHARON BELENZON, LIA SHEER (DUKE UNIVERSITY) / DECEMBER 2020***
********************************************************************************************
********************************************************************************************
*Compiling corporate NPL data and classifying internal vs. corp external citations
*Patent citations to science are obtained from the Non-Patent Literature (NPL) citations section located at the front page of patents taken from the PatStat database.
*We obtain all NPLs related to patents granted in the period 1980-2015.
*Please refer to Online Data Appendix for more details on NPL match, and also a sample code of how we cleaned the raw NPL match is provided in NPL_cleaning_exp.do
*Due to IP restrictions on NPL Data and related WoS publication data is only available at the aggregate permno_adj-year level  
**INPUT: **NOT PROVIDED** due to IP restrictions: NPL match file: "corp_NPL_output_matched_short.dta"
*OUTPUT: NPL citations received per permno_adj-patent grant year: "./data/corp_NPL_cite_per_year_firm_80_15.dta"
*Aggregate permno_adj-year level NPL data are also available in the panel file
***********************************************************************************************

*merging permno_adj related to cited publication and citing patent to NPL match file:
*pub owner:
use "./data/pub_1980_2015.dta" 
keep permno_adj wos_rec
save "./data/pub_1980_2015_short.dta",replace

*wide version of all related UO owners of a patent
use "./data/patent_1980_2015.dta" ,clear
keep publn_nr permno_adj
duplicates drop
sort publn_nr permno_adj
by publn_nr: gen long j=_n 
reshape wide permno_adj, i(publn_nr) j(j)
destring publn_nr, replace
save "./data/patent_1980_2015_short_wide.dta",replace

*merging related permno to NPL match file
**NOT PROVIDED**
use "./data/corp_NPL_output_matched_short.dta",clear
joinby wos_rec using "./data/pub_1980_2015_short.dta"
*we focus only on NPLs by corporate sample patents:
merge m:m publn_nr using "./data/patent_1980_2015_short_wide.dta"
keep if _m==3
drop _m
*classifying internal vs. external citations
sort permno_adj j_date
gen self_cite=1 if permno_adj==permno_adj1 & permno_adj!=. & permno_adj1!=.
replace self_cite=1 if permno_adj==permno_adj2 & permno_adj!=. & permno_adj2!=. & self_cite==.
replace self_cite=1 if permno_adj==permno_adj3 & permno_adj!=. & permno_adj3!=. & self_cite==.
replace self_cite=0 if self_cite==.
label var self_cite "dummy for internal cite=1"
sort permno_adj wos_rec
ren (permno_adj1 permno_adj2 permno_adj3 ) (permno_adj_pat1 permno_adj_pat2 permno_adj_pat3)
label var permno_adj  "cited publication related UO at time of publication"
label var permno_adj_pat1 "citing patent related UO firm 1 "
label var permno_adj_pat2 "citing patent related UO firm 2 if applicable"
label var permno_adj_pat3 "citing patent related UO firm 3 if applicable"
save "./data/corp_NPL_output_merged_80_15.dta",replace

*****************************************************************************

**************************NPL citations received per permno-patent grant year**********************

use "./data/corp_NPL_output_merged_80_15.dta", clear
sort permno_adj publn_year
gen cite=1
collapse (count) cite , by(permno_adj publn_year self_cite)
reshape wide cite  , i(permno_adj publn_year ) j(self_cite)
ren cite0 corp_exter_cites
ren cite1 inter_cites

replace inter_cites=0 if inter_cites==.
replace corp_exter_cites=0 if corp_exter_cites==.

sort permno_adj publn_year
ren publn_year year
label var inter_cites "internal npl cites to own pubs per permno-pat grant year"
label var corp_exter_cites "corp external npl cites to own pubs per permno-pat grant year"
label var year "citing pat grant year"
save "./data/corp_NPL_cite_per_year_firm_80_15.dta", replace


