********************************************************************************************
***DISCERN/ ASHISH ARORA, SHARON BELENZON, LIA SHEER (DUKE UNIVERSITY) / DECEMBER 2020***
********************************************************************************************
********************************************************************************************
*THIS IS THE BASIC STANDARDIZATION CODE WE USED TO STANDARDIZE THE STANDARDIZED NAME LIST FILES. 
*in addition to the code below we manually inspected and cleaned firm names - for example, CRSP tends to abbreviate long words in the company name that it provides. We located those cases and manually corrected them to avoid mismatches
*It is also worth mentioning that the “CRSP Monthly Stock” file reports acronym firm names with extra space between the initial letters (e.g., E G & G INC and not EG&G INC).
*this has to be taken into consideration when performing matches to other databases that do not use this format.
*The standardized names in the subsidiary name list tend to be less structured/cleaned than the UO name list
*Standardized names include legal entity and other common words - in cases where users want to match to a cleaner version of the name, they should apply their own script to further clean the names.
*When matching the name list to other databases users should include extensive manual inspection to matched result. In some cases a m:m match is required.
*Special care should be given to companies with similar names and to generic company names.

gen name_std=upper("enter variable name here")
replace name_std=trim(name_std)
replace name_std=itrim(name_std)
replace name_std=ustrrtrim(name_std)
replace name_std= ustrltrim(name_std)
replace name_std=" " + name_std + " "

*cleaning Compustat related indicators:
replace name_std=subinstr(name_std,"-CL A"," ",.)
replace name_std=subinstr(name_std,"-DEL"," ",.)
replace name_std=subinstr(name_std,"-PRO FORMA"," ",.)
replace name_std=subinstr(name_std," -CL B"," ",.) 
replace name_std=subinstr(name_std,"-ADS"," ",.) 
replace name_std=subinstr(name_std,"-ADR"," ",.) 
replace name_std=subinstr(name_std,"-SVTG"," ",.) 
replace name_std=subinstr(name_std,"-REDH"," ",.) 
replace name_std=subinstr(name_std,"-NEW"," ",.)
replace name_std=regexr(name_std," NEW $"," ")
replace name_std=regexr(name_std," CP $"," ")
replace name_std=subinstr(name_std,"-OLD"," ",.)
replace name_std=regexr(name_std," OLD $"," ")
replace name_std=regexr(name_std," CONSOLIDATED $"," ") 

replace name_std=trim(name_std)
replace name_std=itrim(name_std)
replace name_std=ustrrtrim(name_std)
replace name_std= ustrltrim(name_std)
replace name_std=" " + name_std + " "

replace name_std=subinstr(name_std," AND "," & ",.) 
replace name_std=subinstr(name_std,"&"," & ",.) 
replace name_std=subinstr(name_std,"+"," & ",.) 
replace name_std=subinstr(name_std,"'","",.)
replace name_std=subinstr(name_std,"`","",.)
replace name_std=subinstr(name_std,"-"," ",.)
replace name_std=subinstr(name_std,","," ",.)  
replace name_std=subinstr(name_std,".COM "," COM ",.) 
replace name_std=regexr(name_std, " US $"," ")
replace name_std=regexr(name_std, " U S $"," ")
replace name_std=regexr(name_std, " USA $"," ")
replace name_std=regexr(name_std,char(34)," ")
replace name_std=subinstr(name_std," . "," ",.)
replace name_std=subinstr(name_std,".","",.)
replace name_std=subinstr(name_std,":"," ",.)
replace name_std=subinstr(name_std,";"," ",.)
replace name_std=subinstr(name_std,"'","",.)
replace name_std=subinstr(name_std,"?"," ",.)
replace name_std=subinstr(name_std,"*"," ",.)
replace name_std=subinstr(name_std,"^","",.)
replace name_std=subinstr(name_std,"/"," ",.)
replace name_std=subinstr(name_std,"\"," ",.)
replace name_std=subinstr(name_std,"%"," ",.)
replace name_std=subinstr(name_std,"!"," ",.)
replace name_std=subinstr(name_std,"@"," ",.)
replace name_std=subinstr(name_std,"="," ",.)

*In case you want to drop text in brackets from the name
replace name_std=regexr(name_std,"\((.*)\)"," ") 
replace name_std=regexr(name_std,"\((.*)\)"," ") 
replace name_std=regexr(name_std,"\((.*)\)"," ") 
replace name_std=regexr(name_std,"\((.*) $"," ") 

replace name_std=trim(name_std)
replace name_std=itrim(name_std)
replace name_std=ustrrtrim(name_std)
replace name_std= ustrltrim(name_std)
replace name_std=" " + name_std + " "

*standardizing legal entity:
replace name_std=subinstr(name_std," CORPORATION "," CORP ",.) 
replace name_std=subinstr(name_std," INCORPORATED "," INC ",.) 
replace name_std=subinstr(name_std," INCORP "," INC ",.) 
replace name_std=subinstr(name_std," INCORPORATION "," INC ",.) 
replace name_std=subinstr(name_std," PUB LTD CO "," PLC ",.) 
replace name_std=subinstr(name_std," BANCORPORATION "," BANCORP ",.) 
replace name_std=subinstr(name_std," COS "," CO ",.) 
replace name_std=subinstr(name_std," COMPANIES "," CO ",.) 
replace name_std=subinstr(name_std," COMPANY "," CO ",.) 
replace name_std=subinstr(name_std," COMPN "," CO ",.) 
replace name_std=subinstr(name_std," KONINKLIJKE "," ",.) 
replace name_std=subinstr(name_std," AKTIENGESELLSCHAFT "," AG ",.) 
replace name_std=subinstr(name_std," AKTIENGESELL SCHAFT "," AG ",.) 
replace name_std=subinstr(name_std," LIMITED "," LTD ",.) 
replace name_std=subinstr(name_std," UNLIMITED "," UNLTD ",.) 
replace name_std=regexr(name_std, " CP $"," CORP ")
replace name_std=regexr(name_std, " N V $"," NV ") 
replace name_std=regexr(name_std, " B V $"," BV ")
replace name_std=regexr(name_std, " A S $"," AS ") 
replace name_std=regexr(name_std, " A G $"," AG ") 
replace name_std=regexr(name_std, " K G $"," KG ") 
replace name_std=regexr(name_std, " I N C $"," INC ")
replace name_std=regexr(name_std, " U N L T D $"," UNLTD ")
replace name_std=regexr(name_std, " L T D $"," LTD ")
replace name_std=regexr(name_std, " L L L P $"," LLLP ")
replace name_std=regexr(name_std, " L L P $"," LLP ")
replace name_std=regexr(name_std, " L P $"," LLP ")
replace name_std=regexr(name_std, " P L L C $","  PLLC")
replace name_std=regexr(name_std, " L L C $"," LLC ")
replace name_std=regexr(name_std, " L P $"," LP ")
replace name_std=regexr(name_std, " G M B H $"," GMBH ")
replace name_std=regexr(name_std, " S A R L $"," SARL ")
replace name_std=regexr(name_std, " S P R L $"," SPRL ")
replace name_std=regexr(name_std, " B V B A $"," BVBA ")
replace name_std=regexr(name_std, " L D A $"," LDA ")
replace name_std=regexr(name_std, " Z O O $"," ZOO ")
replace name_std=regexr(name_std, " Z OO $"," ZOO ")
replace name_std=regexr(name_std, " P T Y $"," PTY ")
replace name_std=regexr(name_std, " S R L $"," SRL ")
replace name_std=regexr(name_std, " P L C $"," PLC ")
replace name_std=regexr(name_std, " S A $"," SA ") 
replace name_std=regexr(name_std, " C V $"," CV ") 
replace name_std=regexr(name_std," S DE RL $"," SDERL ") 
replace name_std=regexr(name_std," SA DE CV $"," SADECV ")
replace name_std=subinstr(name_std," KORLATOLT FELELOSSEGU TARSASAG "," KFT ",.) 
replace name_std=subinstr(name_std," GESELLSCHAFT MIT BESCHRAENKTER HAFTUNG "," GMBH ",.) 
replace name_std=subinstr(name_std," GESELLSCHAFT MBH "," GMBH ",.) 
replace name_std=subinstr(name_std," GESELLSCHAFT M B H "," GMBH ",.) 
replace name_std=regexr(name_std," & COKG $"," & CO KG ") 
replace name_std=regexr(name_std, " INC CA $"," INC ") 
replace name_std=regexr(name_std, " INC PA $"," INC ") 
replace name_std=regexr(name_std, " INC WA $"," INC ") 
replace name_std=regexr(name_std, " INC WIS $"," INC ") 
replace name_std=regexr(name_std, " INC UTAH $"," INC ") 
replace name_std=regexr(name_std, " INC NE $"," INC ") 
replace name_std=regexr(name_std, " INC OHIO $"," INC ") 
replace name_std=regexr(name_std, " INC NY $"," INC ") 
replace name_std=regexr(name_std, " INC TENN $"," INC ") 
replace name_std=regexr(name_std, " INC ORE $"," INC ") 
replace name_std=regexr(name_std, " INC MASS $"," INC ") 
replace name_std=regexr(name_std, " INC COLO $"," INC ") 
replace name_std=regexr(name_std, " INC NJ $"," INC ") 
replace name_std=regexr(name_std, " INC TX $"," INC ") 
replace name_std=regexr(name_std, " INC VA $"," INC ") 
replace name_std=regexr(name_std, " INC DEL $"," INC ") 
replace name_std=regexr(name_std, " INC DE $"," INC ") 
replace name_std=regexr(name_std, "INC DELAWARE $"," INC ")
replace name_std=regexr(name_std, " CORP CA $"," CORP ") 
replace name_std=regexr(name_std, " CORP PA $"," CORP ") 
replace name_std=regexr(name_std, " CORP WA $"," CORP ") 
replace name_std=regexr(name_std, " CORP WIS $"," CORP ") 
replace name_std=regexr(name_std, " CORP UTAH $"," CORP ") 
replace name_std=regexr(name_std, " CORP NE $"," CORP ") 
replace name_std=regexr(name_std, " CORP OHIO $"," CORP ") 
replace name_std=regexr(name_std, " CORP NY $"," CORP ") 
replace name_std=regexr(name_std, " CORP TENN $"," CORP ") 
replace name_std=regexr(name_std, " CORP ORE $"," CORP ") 
replace name_std=regexr(name_std, " CORP MASS $"," CORP ") 
replace name_std=regexr(name_std, " CORP COLO $"," CORP ") 
replace name_std=regexr(name_std, " CORP NJ $"," CORP ") 
replace name_std=regexr(name_std, " CORP TX $"," CORP ") 
replace name_std=regexr(name_std, " CORP VA $"," CORP ") 
replace name_std=regexr(name_std, " CORP DEL $"," CORP ") 
replace name_std=regexr(name_std, " CORP DE $"," CORP ") 
replace name_std=regexr(name_std, "CORP DELAWARE $"," CORP ")

replace name_std=subinstr(name_std," UNITED STATES "," US ",.) 
replace name_std=subinstr(name_std, " UNITED KINGDOM "," UK ",.)

*omiting "the"
replace name_std=regexr(name_std, "^ THE "," ")
replace name_std=regexr(name_std, " THE $"," ")

replace name_std=trim(name_std)
replace name_std=itrim(name_std)
replace name_std=ustrrtrim(name_std)
replace name_std= ustrltrim(name_std)
replace name_std=" " + name_std + " "

*standardizing comman words to fit WOS structure:

replace name_std=subinstr(name_std," LABORATORIES "," LAB ",.) 
replace name_std=subinstr(name_std," LABORATORY "," LAB ",.) 
replace name_std=subinstr(name_std," LABS "," LAB ",.) 
replace name_std=subinstr(name_std," LABO "," LAB ",.) 
replace name_std=subinstr(name_std," LABORATORIE "," LAB ",.) 
replace name_std=subinstr(name_std," LABORATARI "," LAB ",.)
replace name_std=subinstr(name_std," LABORATARIO "," LAB ",.)
replace name_std=subinstr(name_std," LABORATARIA "," LAB ",.)
replace name_std=subinstr(name_std," LABORATORIET "," LAB ",.)
replace name_std=subinstr(name_std," LABORATORIUM "," LAB ",.)
replace name_std=subinstr(name_std," LABORATORYS "," LAB ",.)
replace name_std=subinstr(name_std," LABORATORIO "," LAB ",.)
replace name_std=subinstr(name_std," LABORATORIOS "," LAB ",.)
 

replace name_std=subinstr(name_std," CALIFORNIA "," CALIF ",.) 

replace name_std=subinstr(name_std," PETROLEUM "," PETR ",.) 

replace name_std=subinstr(name_std," MACHINES "," MACH ",.) 
replace name_std=subinstr(name_std," MACHINE "," MACH ",.) 
replace name_std=subinstr(name_std," MACHINERY "," MACH ",.) 



replace name_std=subinstr(name_std," HOLDING "," HLDG ",.) 
replace name_std=subinstr(name_std," HOLDINGS "," HLDG ",.) 
replace name_std=subinstr(name_std," HLDGS "," HLDG ",.)
replace name_std=subinstr(name_std," HLDS "," HLDG ",.)
replace name_std=subinstr(name_std," HLDNGS "," HLDG ",.)



replace name_std=subinstr(name_std," GROUP "," GRP ",.) 
replace name_std=subinstr(name_std," GROUPS "," GRP ",.) 
replace name_std=subinstr(name_std," GRPS "," GRP ",.) 
replace name_std=regexr(name_std, " GP $"," GRP ")
replace name_std=regexr(name_std, " GP INC $"," GRP INC ")


replace name_std=subinstr(name_std," SCIENCES "," SCI ",.) 
replace name_std=subinstr(name_std," SCIENCE "," SCI ",.) 
replace name_std=subinstr(name_std," SCIENTIFIC "," SCI ",.) 
replace name_std=subinstr(name_std," SCIENTIFICS "," SCI ",.) 


replace name_std=subinstr(name_std," NEUROSCIENCE "," NEUROSCI ",.) 


replace name_std=subinstr(name_std," SYSTEMS "," SYS ",.) 
replace name_std=subinstr(name_std," SYSTEM "," SYS ",.) 
replace name_std=subinstr(name_std," SYST "," SYS ",.) 
replace name_std=subinstr(name_std," SYSTS "," SYS ",.) 

replace name_std=subinstr(name_std," MICROSYSTEM "," MICROSYS ",.) 
replace name_std=subinstr(name_std," MICROSYSTEMS "," MICROSYS ",.) 
replace name_std=subinstr(name_std," MICROSYST "," MICROSYS ",.) 



replace name_std=subinstr(name_std," MEDICAL "," MED ",.) 
replace name_std=subinstr(name_std," MEDICALS "," MED ",.) 
replace name_std=subinstr(name_std," MEDICINE "," MED ",.) 
replace name_std=subinstr(name_std," MEDICINES "," MED ",.) 
replace name_std=subinstr(name_std," MEDICATION "," MED ",.) 
replace name_std=subinstr(name_std," MEDICATIONS "," MED ",.) 




replace name_std=subinstr(name_std," PHARMACEUTICALS "," PHARM ",.) 
replace name_std=subinstr(name_std," PHARMACEUTICAL "," PHARM ",.)  
replace name_std=subinstr(name_std," PHARMACEUTICL "," PHARM ",.)  
replace name_std=subinstr(name_std," PHARMACEUTICLS "," PHARM ",.)  

replace name_std=subinstr(name_std," PHARMACEUT "," PHARM ",.)  
replace name_std=subinstr(name_std," PHARMA "," PHARM ",.) 
replace name_std=subinstr(name_std," PHARMACEUTICS "," PHARM ",.) 
replace name_std=subinstr(name_std," PHARMACEUTIC "," PHARM ",.) 

replace name_std=subinstr(name_std," PHARMACTLS "," PHARM ",.) 
replace name_std=subinstr(name_std," PHARMACTCL "," PHARM ",.) 
 


replace name_std=subinstr(name_std," INDUSTRY "," IND ",.) 
replace name_std=subinstr(name_std," INDUSTRIES "," IND ",.) 
replace name_std=subinstr(name_std," INDS "," IND ",.) 
replace name_std=subinstr(name_std," INDUSTRIAL "," IND ",.) 
replace name_std=subinstr(name_std," INDUSTRIALS "," IND ",.) 
replace name_std=subinstr(name_std," INDUS "," IND ",.) 


replace name_std=subinstr(name_std," INTERNATIONAL "," INTL ",.)
replace name_std=subinstr(name_std," INTERNATIONALS "," INTL ",.) 
replace name_std=subinstr(name_std," INTERNATNAL "," INTL ",.) 
replace name_std=subinstr(name_std," INT "," INTL ",.) 



replace name_std=subinstr(name_std," CHEMICAL "," CHEM ",.) 
replace name_std=subinstr(name_std," CHEMICALS "," CHEM ",.) 
replace name_std=subinstr(name_std," CHEMS "," CHEM ",.) 
replace name_std=subinstr(name_std," PETROCHEMICAL "," PETROCHEM ",.) 
replace name_std=subinstr(name_std," PETROCHEMICALS "," PETROCHEM ",.) 


replace name_std=subinstr(name_std," MANUFACTURING "," MFG ",.) 
replace name_std=subinstr(name_std," MANUFACTURINGS "," MFG ",.) 
replace name_std=subinstr(name_std," MANUFACTURE "," MFG ",.) 
replace name_std=subinstr(name_std," MANUFACTURES "," MFG ",.) 
replace name_std=subinstr(name_std," MANUFACTURERS "," MFG ",.) 
replace name_std=subinstr(name_std," MANUFACTURER "," MFG ",.) 


replace name_std=subinstr(name_std," TECHNOLOGY "," TECH ",.) 
replace name_std=subinstr(name_std," TECHNOLOGIES "," TECH ",.) 
replace name_std=subinstr(name_std," TECHNOL "," TECH ",.) 
replace name_std=subinstr(name_std," TEKNOLOGIES "," TECH ",.) 
replace name_std=subinstr(name_std," TECHNOLGIES "," TECH ",.)
replace name_std=subinstr(name_std," TECHNS "," TECH ",.) 
replace name_std=subinstr(name_std," TECHN "," TECH ",.) 
replace name_std=subinstr(name_std," TECHS "," TECH ",.) 
replace name_std=subinstr(name_std," TECHNLGS "," TECH ",.) 
replace name_std=subinstr(name_std," TECHNLG "," TECH ",.) 



replace name_std=subinstr(name_std," HEALTHCARE "," HLTHCR ",.) 
replace name_std=subinstr(name_std," HEALTH CARE "," HLTHCR ",.) 
replace name_std=subinstr(name_std," HEALTH-CARE "," HLTHCR ",.) 
replace name_std=subinstr(name_std," HEALTH "," HLTH ",.) 


 
replace name_std=subinstr(name_std," SOFTWARE "," SFTWR ",.) 
replace name_std=subinstr(name_std," SOFTWARES "," SFTWR ",.) 
replace name_std=subinstr(name_std," SFTWRS "," SFTWR ",.) 
replace name_std=subinstr(name_std," SOFTWR "," SFTWR ",.) 



replace name_std=subinstr(name_std," DEVELOPMENTS "," DEV ",.) 
replace name_std=subinstr(name_std," DEVELOPMENT "," DEV ",.) 
replace name_std=subinstr(name_std," DVLPMNT "," DEV ",.) 

 
replace name_std=subinstr(name_std," RESOURCES "," RESORC ",.) 
replace name_std=subinstr(name_std," RESOURCE "," RESORC ",.) 
replace name_std=subinstr(name_std," RESEARCH "," RES ",.) 
replace name_std=subinstr(name_std," RESEARCHES "," RES ",.) 
replace name_std=subinstr(name_std," RECH "," RES ",.) 
replace name_std=subinstr(name_std," RESH "," RES ",.) 
replace name_std=subinstr(name_std," R & D "," RES & DEV ",.) 

replace name_std=subinstr(name_std," NATIONAL "," NATL ",.) 
replace name_std=subinstr(name_std," NATIONALS "," NATL ",.) 


replace name_std=subinstr(name_std," INFORMATION "," INFO ",.) 
replace name_std=subinstr(name_std," INFORMAT "," INFO ",.) 

replace name_std=subinstr(name_std," BIO-TECH "," BIOTECH ",.) 
replace name_std=subinstr(name_std," BIOTECHNOLOGY "," BIOTECH ",.)
replace name_std=subinstr(name_std," BIOTECHNOLOGIES "," BIOTECH ",.) 
replace name_std=subinstr(name_std," BIOTECHNOL "," BIOTECH ",.) 


replace name_std=subinstr(name_std," NANOTECHNOLOGY "," NANOTECH ",.)
replace name_std=subinstr(name_std," NANOTECHNOLOGIES "," NANOTECH ",.) 
replace name_std=subinstr(name_std," NANOTECHNOL "," NANOTECH ",.) 

replace name_std=subinstr(name_std," BIOTHERAPEUTC "," BIOTHERAPEUT ",.)
replace name_std=subinstr(name_std," BIOTHERAPEUTCS "," BIOTHERAPEUT ",.) 
replace name_std=subinstr(name_std," BIOTHERAPEUTIC "," BIOTHERAPEUT ",.) 
replace name_std=subinstr(name_std," BIOTHERAPEUTICS "," BIOTHERAPEUT ",.) 

replace name_std=subinstr(name_std," THERAPEUTC "," THERAPEUT ",.)
replace name_std=subinstr(name_std," THERAPEUTCS "," THERAPEUT ",.) 
replace name_std=subinstr(name_std," THERAPEUTIC "," THERAPEUT ",.) 
replace name_std=subinstr(name_std," THERAPEUTICS "," THERAPEUT ",.) 
 

 

replace name_std=subinstr(name_std," SOLUTION "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLUTIONS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLUTS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLTNS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLTN "," SOLUT ",.)
replace name_std=subinstr(name_std," SOLTNS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLNS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLUTNS "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLUTINS "," SOLUT ",.) 


replace name_std=subinstr(name_std," BIOSCIENCES "," BIOSCI ",.) 
replace name_std=subinstr(name_std," BIOSCIENCE "," BIOSCI ",.) 

replace name_std=subinstr(name_std," BIOMEDICAL "," BIOMED ",.) 


replace name_std=subinstr(name_std," ELECTRONICS "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELECTRONIC "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELECTRS "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELECTRIC "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELECTRICS "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELECT "," ELECTR ",.) 
replace name_std=subinstr(name_std," ELEC "," ELECTR ",.) 


replace name_std=subinstr(name_std," MICROELECTRONICS "," MICROELECTR ",.) 
replace name_std=subinstr(name_std," MICROELECTRONIC "," MICROELECTR ",.) 



replace name_std=subinstr(name_std," INSTITUTES "," INST ",.) 
replace name_std=subinstr(name_std," INSTITUTE "," INST ",.) 
replace name_std=subinstr(name_std," CENTER "," CTR ",.) 




replace name_std=subinstr(name_std," TELECOMMUNICATIONS "," TELECOM ",.) 
replace name_std=subinstr(name_std," TELECOMMUNICATION "," TELECOM ",.) 
replace name_std=subinstr(name_std," TELECOMMUN "," TELECOM ",.) 
replace name_std=subinstr(name_std," TELECOMM "," TELECOM ",.) 
replace name_std=subinstr(name_std," TELEKOM "," TELECOM ",.) 
replace name_std=subinstr(name_std," TELECOMMUNICATNS "," TELECOM ",.) 


replace name_std=subinstr(name_std," BIOPHARMACEUTICAL "," BIOPHARM ",.) 
replace name_std=subinstr(name_std," BIOPHARMACEUTICALS "," BIOPHARM ",.) 
replace name_std=subinstr(name_std," BIOPHARMA "," BIOPHARM ",.) 
replace name_std=subinstr(name_std," BIOPHARMACEUT "," BIOPHARM ",.) 


replace name_std=subinstr(name_std," COMMUNICATION "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMUNICATIONS "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMUNICATI "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMUNICATN "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMUNICATNS "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMUNICAT "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMM "," COMMUN ",.) 
replace name_std=subinstr(name_std," COMMS "," COMMUN ",.) 




replace name_std=subinstr(name_std," ANIMAL "," ANIM ",.) 

replace name_std=subinstr(name_std," BIOLOGICAL "," BIOL ",.) 
replace name_std=subinstr(name_std," BIOLOGY "," BIOL ",.) 
replace name_std=subinstr(name_std," BIOLOGICS "," BIOL ",.) 


replace name_std=subinstr(name_std," PHYSICS "," PHYS ",.) 
 
replace name_std=subinstr(name_std," COMPUTER "," COMP ",.) 
replace name_std=subinstr(name_std," COMPUTERS "," COMP ",.) 
replace name_std=subinstr(name_std," COMPUTING "," COMP ",.) 


replace name_std=subinstr(name_std," ENGINEERING "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGINEERINGS "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGINEER "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGINEERS "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGNS "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGINE "," ENGN ",.) 
replace name_std=subinstr(name_std," ENGIN "," ENGN ",.)
replace name_std=subinstr(name_std," ENGR "," ENGN ",.)


replace name_std=subinstr(name_std," SOLUTION "," SOLUT ",.) 
replace name_std=subinstr(name_std," SOLUTIONS "," SOLUT ",.) 

replace name_std=subinstr(name_std," SERVICES "," SERV ",.) 
replace name_std=subinstr(name_std," SERVICE "," SERV ",.) 
replace name_std=subinstr(name_std," SRVS "," SERV ",.) 
replace name_std=subinstr(name_std," SVCS "," SERV ",.) 
replace name_std=subinstr(name_std," SVC "," SERV ",.) 
replace name_std=subinstr(name_std," SRVCS "," SERV ",.)
replace name_std=subinstr(name_std," SVSCS "," SERV ",.) 
 

replace name_std=subinstr(name_std," SURGICAL "," SURG ",.) 
replace name_std=subinstr(name_std," BIOSURGICAL "," BIOSURG ",.) 
replace name_std=subinstr(name_std," SURGERY "," SURG ",.) 
replace name_std=subinstr(name_std," SURGERIES "," SURG ",.) 

replace name_std=subinstr(name_std," ASSOCS "," ASSOC ",.) 
replace name_std=subinstr(name_std," ASSOCIATES "," ASSOC ",.) 
replace name_std=subinstr(name_std," ASSOCIATE "," ASSOC ",.) 
replace name_std=subinstr(name_std," ASSC "," ASSOC ",.) 


replace name_std=subinstr(name_std," INSTRUMENT "," INSTR ",.) 
replace name_std=subinstr(name_std," INSTRUMENTS "," INSTR ",.) 
replace name_std=subinstr(name_std," INSTRS "," INSTR ",.) 

 
replace name_std=subinstr(name_std," PRODUCT "," PROD ",.) 
replace name_std=subinstr(name_std," PRODUCTS "," PROD ",.) 
replace name_std=subinstr(name_std," PRODUCTION "," PROD ",.) 
replace name_std=subinstr(name_std," PRODUCTIONS "," PROD ",.) 
replace name_std=subinstr(name_std," PRD "," PROD ",.) 
replace name_std=subinstr(name_std," PRDUS "," PROD ",.) 
replace name_std=subinstr(name_std," PRODS "," PROD ",.) 



replace name_std=subinstr(name_std," ANALYTICS "," ANALYT ",.) 
replace name_std=subinstr(name_std," ANALYTICAL "," ANALYT ",.) 
replace name_std=subinstr(name_std," ANALYTIC "," ANALYT ",.)

replace name_std=subinstr(name_std," ANALYSIS "," ANAL ",.) 
 
  
replace name_std=subinstr(name_std," DYNAMICS "," DYNAM ",.) 
replace name_std=subinstr(name_std," DYNAMIC "," DYNAM ",.) 

replace name_std=subinstr(name_std," INTERACTIVE "," INTERACT ",.) 

replace name_std=subinstr(name_std," AUTOMATIVE "," AUTOMAT ",.) 
replace name_std=subinstr(name_std," AUTOMATION "," AUTOMAT ",.) 
replace name_std=subinstr(name_std," AUTOMATN "," AUTOMAT ",.) 
replace name_std=subinstr(name_std," AUTOMATIC "," AUTOMAT ",.) 
replace name_std=subinstr(name_std," AUTOMOTIVE "," AUTOMOT ",.) 
replace name_std=subinstr(name_std," AUTOMOTIV "," AUTOMOT ",.) 
replace name_std=subinstr(name_std," AUTOMATED "," AUTOMAT ",.) 

  
replace name_std=subinstr(name_std," SEMICONDUCTOR "," SEMICOND ",.) 
replace name_std=subinstr(name_std," SEMICONDUCTORS "," SEMICOND ",.) 
replace name_std=subinstr(name_std," SEMICON "," SEMICOND ",.) 
replace name_std=subinstr(name_std," SEMICNDCTR "," SEMICOND ",.) 

 
replace name_std=subinstr(name_std," BIOSYSTEMS "," BIOSYS ",.) 
replace name_std=subinstr(name_std," BIOSYSTEM "," BIOSYS ",.) 
replace name_std=subinstr(name_std," BIOSYST "," BIOSYS ",.) 

replace name_std=subinstr(name_std," INVESTMENT "," INVEST ",.) 
replace name_std=subinstr(name_std," INVESTMENTS "," INVEST ",.) 
       
replace name_std=subinstr(name_std," SURGICAL "," SURG ",.) 
replace name_std=subinstr(name_std," SURGERY "," SURG ",.) 
 
replace name_std=subinstr(name_std," GENETIC "," GENET ",.) 
replace name_std=subinstr(name_std," GENETICS "," GENET ",.) 
replace name_std=subinstr(name_std," GENETICAL "," GENET ",.) 

replace name_std=subinstr(name_std," HOSPITAL "," HOSP ",.) 

replace name_std=subinstr(name_std," DIAGNOSTIC "," DIAGNOST ",.) 
replace name_std=subinstr(name_std," DIAGNOSTICS "," DIAGNOST ",.) 

replace name_std=subinstr(name_std," ONCOLOGY "," ONCOL ",.) 
replace name_std=subinstr(name_std," ONCOLYTICS "," ONCOL ",.) 

replace name_std=subinstr(name_std," EDUCATION "," EDUC ",.) 
replace name_std=subinstr(name_std," EDUCATIONS "," EDUC ",.) 
replace name_std=subinstr(name_std," EDU "," EDUC ",.) 

replace name_std=subinstr(name_std," NUTRITION "," NUTR ",.) 

replace name_std=subinstr(name_std," SECURITY "," SECUR ",.) 
replace name_std=subinstr(name_std," SECURITIES "," SECUR ",.) 
replace name_std=subinstr(name_std," SECURE "," SECUR ",.) 

replace name_std=subinstr(name_std," NAVIGATION "," NAVIGAT ",.) 
       
replace name_std=subinstr(name_std," MOLECULAR "," MOLEC ",.) 
replace name_std=subinstr(name_std," MOLECULE "," MOLEC ",.) 

replace name_std=subinstr(name_std," INNOVATION "," INNOVAT ",.) 
replace name_std=subinstr(name_std," INNOVATIONS "," INNOVAT ",.) 
replace name_std=subinstr(name_std," INNOVATIVE "," INNOVAT ",.) 
replace name_std=subinstr(name_std," INNOV "," INNOVAT ",.) 


replace name_std=subinstr(name_std," MATERIAL "," MAT ",.) 
replace name_std=subinstr(name_std," MATERIALS "," MAT ",.) 
replace name_std=subinstr(name_std," MATL "," MAT ",.) 
replace name_std=subinstr(name_std," MATLS "," MAT ",.) 


replace name_std=subinstr(name_std," ADVANCED "," ADV ",.) 
replace name_std=subinstr(name_std," ADVANCE "," ADV ",.) 

replace name_std=subinstr(name_std," MOLECULAR "," MOLEC ",.) 
replace name_std=subinstr(name_std," MOLECULARS "," MOLEC ",.) 

replace name_std=subinstr(name_std," AGRICULTURE "," AGR ",.) 
replace name_std=subinstr(name_std," AGRICULTURES "," AGR ",.) 
 
replace name_std=subinstr(name_std," ENVIRONMENT "," ENVIRONM ",.) 
replace name_std=subinstr(name_std," ENVIRONMENTS "," ENVIRONM ",.) 
replace name_std=subinstr(name_std," ENVIRONMENTAL "," ENVIRONM ",.) 
replace name_std=subinstr(name_std," ENVIRONMTL "," ENVIRONM ",.) 


replace name_std=subinstr(name_std," APPLICATION "," APPLICAT ",.)
replace name_std=subinstr(name_std," APPLICATIONS "," APPLICAT ",.)
replace name_std=subinstr(name_std," APPS "," APPLICAT ",.)
 
replace name_std=subinstr(name_std," AEROSPACE "," AEROSP ",.)
replace name_std=subinstr(name_std," PHOTONICS "," PHOTON ",.)
replace name_std=subinstr(name_std," PHOTONIC "," PHOTON ",.)
replace name_std=subinstr(name_std," CLINICAL "," CLIN ",.)
replace name_std=subinstr(name_std," GENERAL "," GEN ",.)
replace name_std=subinstr(name_std," GENERALS "," GEN ",.)
replace name_std=subinstr(name_std," GRAPHIC "," GRAPH ",.)
replace name_std=subinstr(name_std," GRAPHICS "," GRAPH ",.)

replace name_std=subinstr(name_std," APPLIED "," APPL ",.)
replace name_std=subinstr(name_std," FLAVORS "," FAVORS ",.)

replace name_std=subinstr(name_std," TRANSPORTATION "," TRANSPORTAT ",.)
replace name_std=subinstr(name_std," TRANSPORTATIONS "," TRANSPORTAT ",.)

replace name_std=subinstr(name_std," AMERICA "," AMER ",.)
replace name_std=subinstr(name_std," AMERICAN "," AMER ",.)
replace name_std=subinstr(name_std," AMERICAS "," AMER ",.)


replace name_std=subinstr(name_std," TELEPHONE "," TEL ",.)
replace name_std=subinstr(name_std," TELEPHONES "," TEL ",.)

replace name_std=subinstr(name_std," ORTHOPAEDICS "," ORTHOPAED ",.)
replace name_std=subinstr(name_std," ORTHOPAEDIC "," ORTHOPAED ",.)

replace name_std=subinstr(name_std," AEROSPACE "," AEROSP ",.)

replace name_std=subinstr(name_std," MECHANICAL "," MECHAN ",.)


replace name_std=subinstr(name_std," ASSOCIATION "," ASSOC ",.)
replace name_std=subinstr(name_std," ASSOCIATIONS "," ASSOC ",.)

replace name_std=subinstr(name_std," DISPLAY "," DISP ",.)
replace name_std=subinstr(name_std," DISPLAYS "," DISP ",.)

replace name_std=subinstr(name_std," DIVISION "," DIV ",.)
replace name_std=subinstr(name_std," DIVISIONS "," DIV ",.)


replace name_std=subinstr(name_std," EQUIPMENT "," EQUIP ",.)
replace name_std=subinstr(name_std," EQUIPMENTS "," EQUIP ",.)

replace name_std=subinstr(name_std," INTELLECTUAL PROPERTY "," IP ",.)
replace name_std=subinstr(name_std," INTELLECTUAL PROPERTIES "," IP ",.)

replace name_std=subinstr(name_std," MANAGEMENT "," MGMT ",.)
replace name_std=subinstr(name_std," MANAGEMENTS "," MGMT ",.)

replace name_std=subinstr(name_std," OPTICS "," OPTIC ",.)
replace name_std=subinstr(name_std," NETWORKS "," NETWORK ",.)
replace name_std=subinstr(name_std," NTWRK "," NETWORK ",.)
replace name_std=subinstr(name_std," NTWK "," NETWORK ",.)

 
replace name_std=subinstr(name_std," CENTERS "," CTR ",.) 
replace name_std=subinstr(name_std," UNIVERSITY "," UNIV ",.) 
replace name_std=subinstr(name_std," UNIVERSITIES "," UNIV ",.) 


replace name_std=subinstr(name_std," TOB "," TOBACCO ",.) 
replace name_std=subinstr(name_std," MNG "," MINING ",.) 
replace name_std=subinstr(name_std," ENTERPRS "," ENTERPRISE ",.) 

replace name_std=trim(name_std)
replace name_std=itrim(name_std)
replace name_std=ustrrtrim(name_std)
replace name_std= ustrltrim(name_std)

