# Contributing
When contributing to this repository, please first discuss the change you wish to make via an issue, email, or any other method with the owners of this repository before investing a lot of time in writing changes. 

Please note we have a [code of conduct](https://github.com/softwaresaved/event-organisation-guide/blob/master/CODE_OF_CONDUCT.md), please follow it in all your interactions with the project.

Please make sure any contributions also adhere to the EOG [Style](https://github.com/softwaresaved/event-organisation-guide/blob/master/STYLE.md) guide. 

## What's the purpose of the EOG
The purpose of the SSI EOG is to document how the [SSI](https://www.software.ac.uk), related individual's (e.g. the [SSI Fellows](https://www.software.ac.uk/about/fellows)) and the wider research software community organise events.

## What's the scope of the EOG
The scope of the Event Organisation Guide (EOG) is limitied to (mainly) experiential knowledge; to keep the guide focused, consistent in approach and not too large. 

### In scope 
The EOG is looking to capture actual experience from running events and so the contributions are limited to:

1. ACTUAL - Contributions about event organisation where you **actually** did the things you are contributing as updates or a case study to the guide.
2. PLANNED - Things you will definately do next time you run an event that show a strong understanding of how to integrate a new approach.
3. LINKS - We are happy to link to other resources if we think it's appropriate, please tell us where it should be linked from in the EOG.
4. AOB - We are a friendly bunch - if you have an idea which you think falls into the 'experiential' rather than 'theoretical' category for the EOG - raise an issue and we can start a conversation.

ACTUAL contribution type information is preferred over PLANNED.

### Out of scope
What is out of scope for the EOG:

+ I found this good guide and can you integrate it into EOG
+ Theorectical event planning is out of scope - we are after experiential knowledge in the EOG
+ I found this link - you should refer to it from the EOG (see 3. above - tell us in which section and why)

## Processes for contributing changes

### Pull Request Process (preferred)
1. Ensure any install or build dependencies are removed.
2. Make sure contributions follow the EOG [Style](https://github.com/softwaresaved/event-organisation-guide/blob/master/STYLE.md) considerations.
3. Reference the Issue which this Pull Request (PR) is associated with.
4. Make a Pull Request
5. We will use the [GitHub Flow](https://guides.github.com/introduction/flow/) pattern for working with and accepting changes. Review and any merges of the PR will be performed by @shoaibsufi in the first instance, or @rainsworth if @shoaibsufi is not available.

### Document Based Process (acceptable)
1. Copy the text from the section of the EOG that you are modifying into a Google Document, Word file, Office 365, or OpenOffice (or LibreOffice) Writer
2. Use track change or suggesting functionailty to make changes and additions
3. Raise an [issue](https://github.com/softwaresaved/event-organisation-guide/issues) and explain the changes and additions you have made
4. Attach the link to the Google Document or Office 365 Word or attach the Word or OpenOffice(LibreOffice) file to the issue - note you must have all changes in track changes or suggesting format
5. @shoaibsufi will check the changes you are suggesting and discuss matters with you in the issue you have raised, @rainsworth will proceed matters if @shoaibsufi is not available.

## Authorship and Acknowledgement

### Authorship
If you are offering substantial changes to a section or additional sections (e.g. case studies) then if your porposed contributions are accepted you will be listed as an [Author](https://github.com/softwaresaved/event-organisation-guide/blob/master/docs/eog/authors.rst).

### Acknowledgement
If you offer:

1. Offer numberous typographical corrections which are accepted
2. Substantive review comments which are later actioned
3. Previously published reference material which you allow us to include and it is included
4. Other contributions which are deemed as substantive by the repository owners

You will be acknowledged as a [Contributor](https://github.com/softwaresaved/event-organisation-guide/blob/master/docs/eog/authors.rst).

If you offer the odd typographical correction, suggest a link to include or some re-wording then we thank you but you won't make the Contributor list.
