
# Quantifying the influence of space on social group structure

#### Authors:
- Julian Evans<sup>1†*</sup>,
- Jonas I. Liechti<sup>2†</sup>,
- Matthew J. Silk<sup>3,4</sup>,
- Barbara König<sup>1‡</sup>,
- Sebastian Bonhoeffer<sup>2‡</sup>

1: _Department of Evolutionary Biology and Environmental Studies,
      University of Zurich, Winterthurerstrasse 190, 8057 Zurich_ <br>
2: _Institute for Integrative Biology,
      ETH Zurich, Universitätsstrasse 16, 8092 Zurich, Switzerland_<br>
3: _Centre for Ecology and Conservation,
      University of Exeter Penryn Campus, UK_<br>
4: _Environment and Sustainability Institute,
      University of Exeter Penryn Campus, UK_<br>
†: _Joint first author_<br>
‡: _Joint last author_<br>
*:  _Corresponding author: jevansbio@gmail.com_


# Dataset
The raw data of the studied system is present in `graphs` folder in form of a
list of [GraphML](http://graphml.graphdrawing.org/) files.
The files containing the graphs are numbered according to their order of
appearance in the sequence of graphs.

Each file contains a single graph the can be imported for example into
[igraph](https://igraph.org/r/doc/).

The following attributes are stored in the graphml files:

### Graph properties:

  - start (xml tag: g_start) gives the starting timepoint of
      aggregation period. The format is `'YYYY-MM-DD HH:MM:SS'`.
  - stop (xml tag: g_stop) gives the ending timepoint of the
      aggregation period.

### Node properties:

  - name (xml tag: v_name) a unique id for each individual that is consistent
      across the sequence of graphs.
  - x position( xml tag: v_x) is the x position [cm] of the barycentre from
      all interactions of this individual.
  - y position( xml tag: v_y) is the x position [cm] of the barycentre from
      all interactions of this individual.

### Edge properties:

  - weight (xml tag: e_weight) is the weight [seconds] of an interaction.
      The weight corresponds to the accumulated duration of interactions.
