#!/bin/bash
## V.HANOKA, juillet 2010.
EVAL_PATH=`dirname $0`
 
set -o nounset
set -o errexit
set -o pipefail

#echo "$*"; 
name=$1
lang=$2
method=$3
shift 3

workdir=results.$lang.$method

res=$(head -11 $workdir/data/ALL-RESULTS.txt|sed -e 's/\s/~~~/g' -e 's/$/\\\\\\\\/g' );
sum=$(tail -8 $workdir/data/ALL-RESULTS.txt |sed -e 's/\s/~/g'   -e 's/$/\\\\\\\\/g' );
resgraph="$workdir\/data\/ALL-RESULTS-GRAPH.png"

sed -e "s/==ALL-RES==/`echo $res`/" -e "s/==ALL-RES-GRAPH==/`echo $resgraph`/"  -e "s/==SUMMARY==/`echo $sum`/" -e 's/^\\\\//g' $EVAL_PATH/synthese.tex > $workdir/data/synthese.tex;

    matrix="\\\section{Language: $lang}
            \\\subsection{Confusion matrix obtained for $lang}
               \\\includegraphics[scale=0.35]{$workdir\/data\/ALL-MATRIX.png}
               \\\\\\\\\\~\\\\\\\\\\ \\\scriptsize 
            \\\subsubsection{Tags\/matrix axes mapping}
               \\\\ \\\flushleft 
               \\\begin{multicols}{2} ==CORRESP== \\\end{multicols}
            \\\subsection{List of 100 first errors for $lang (decreasing freq.)}
               \\\normalsize 
               1st column: error apparition frequency \\\\\\\\\\
               2nd column: reference tag  \\\\\\\\\\
               3rd column: LIMA tag \\\\\\\\\\
               4th column: token concerned \\\\\\\\\\~\\\\\\\\\\
               \\\scriptsize 
               \\n\\\begin{longtable}{l l l l}\\n   ==ERR==  \\n\\\end{longtable} "  

    
    c=$(cat "$workdir/data/ALL-MATRIX.corresp" | sed -e 's/^L_//g'  -e 's/_/-/g' -e 's/\$/\\\\\\\\$/'  -e 's/$/~\\\\\\\\\\\\\\\\ /g');
#     er=$(head -100 "data/ALL-ERRORS-$lang.txt" | sed -e 's/^/\\\\\\\\tabenumitem /' -e 's/\t/\\\\n\\\\\\\\tabenumitem /g' -e 's/$/\\\\n\\\\n/' -e 's/%/\\\\\\\\%/g' -e 's/\$/\\\\\\\\$/g' -e 's/_/-/g');
    er=$(head -100 "$workdir/data/ALL-ERRORS.txt" | sed -e 's|/|\\\\\\\/|g' -e 's/\t/\\\\\\\&/g' -e 's/$/\\\\\\\\\\\\\\\\\\\\n/' -e 's/%/\\\\\\\\%/g' -e 's/\$/\\\\\\\\$/g' -e 's/_/-/g');
    e=$(echo $matrix |  sed -e "s/==CORRESP==/`echo $c`/" -e "s/==ERR==/`echo $er`/");
    sed -i -e  "s/==MATRIX==/`echo $e`\n&/"  $workdir/data/synthese.tex;
#     rm err.tmp;

sed -i -e "s/==MATRIX==//"  $workdir/data/synthese.tex; 

pdflatex -interaction=batchmode $workdir/data/synthese.tex;
mv synthese.pdf $name
rm synthese.aux synthese.log;
echo "Generated $name."
