#!/usr/bin/perl
## V.HANOKA, juillet 2010.
# arg1: code de la langue envisagée,
# arg2: liste des tags ordonnée pour cette langue.

use strict;
my %matrix;
my %tagset;
my $lang = $ARGV[0];
my $method = $ARGV[1];
my @tags = split(',' , $ARGV[2]);
my $nbParts =  $ARGV[3];

# Construction du hash Tag_Reference{Tag_Predit{nb_occurences}}
foreach (1 .. $nbParts){
  open(RES, "< results.$lang.$method/$_/aligned") or die "Impossible d'ouvrir le fichier results.$lang.$method/$_/aligned \n";
  while (<RES>){
    $_ =~ s/(<CASE no=[0-9]+>)?<TOK tag//g;
    (my $rien, my $s1, my $s2)=split /=/, $_;
    my @tagref = split(/>/, $s1);
    my @tagsys = split(/>/, $s2);
    $matrix{$tagref[0]}{$tagsys[0]}++;
    $tagset{$tagref[0]}+=1;
      }
    }
  close RES;

#print "$_\t" foreach(@tags);
for my $ligne (0 .. $#tags) {
   for my $colonne (0 .. $#tags) {
     if ($matrix{$tags[$ligne]}{$tags[$colonne]}){
       print $matrix{$tags[$ligne]}{$tags[$colonne]}/$tagset{$tags[$ligne]}."\t";
       }
     else{
       print "0\t";
     }
   }
   print "\n";
}
