#!/usr/bin/perl  
use Cwd;

my $lang = $ARGV[0];
my $method= $ARGV[1];
my $nbPart = 10;
if ($#ARGV >= 2)
{
  $nbPart = $ARGV[2];
}
my $cpt = 0;
open(TMP1, ">tmp1") or die "Impossible de créer le fichier tmp1 \n";
foreach $d (1 .. $nbPart){
    open(FILE, "< results.$lang.$method/$d/aligned") or die "Impossible d'ouvrir fichier aligned de results.$lang.$method/$d\n";
    while (<FILE>){
      chomp;
      if (/<CASE no=.+><TOK tag=(.+)>(.+)<TOK tag=(.+)>.+/){
        if ($1 ne $3) {print TMP1 "$1\t$3\t$2\n"; $cpt++;}
      }
    }   
    close FILE;
}
print " (Nb erreurs : $cpt)";
close TMP1;

system ("echo 'Nb erreurs : $cpt\n\n' > results.$lang.$method/data/ALL-ERRORS.txt");
system("sort tmp1 | uniq -ci | sort -nr | sed  -e 's/ # /\t/g' -e 's/   *//g' -e 's/ /\t/g' >> results.$lang.$method/data/ALL-ERRORS.txt; rm tmp1");
print "---> results.$lang.$method/data/ALL-ERRORS.txt";
