#!/bin/bash

set -o nounset
set -o errexit
set -o pipefail

## V.HANOKA, juillet 2010.

# arg1: langue 
date=$(date);

lang=$1
method=$2
nbParts=$3
shift 3


EVAL_PATH=`dirname $0`

###########################################################
# Classement des tags présents dans le corpus d'entraînement
# par ordre de fréquence croissant:
tags=$(cat results.$lang.$method/1/10pc.tfcv results.$lang.$method/1/90pc.tfcv |\
       gawk -F'\t' '{print $2}' |\
       sort | uniq -c | sort -n |\
       gawk -F' ' '{print $2}'| tr '\n' ',');


############################################################
# Extraction de la matrice de confusion (valeurs numériques):
echo "$EVAL_PATH/matriceConfusion.pl $lang $method $tags $nbParts > results.$lang.$method/data/ALL-MATRIX.txt;"
$EVAL_PATH/matriceConfusion.pl $lang $method $tags $nbParts > results.$lang.$method/data/ALL-MATRIX.txt;


###############################################################################
# Construction du graph correspondant (nécessite R et le script MyImagePlot.r):
echo "R --vanilla --slave  <<< \"source('$EVAL_PATH/MyImagePlot.r')
d <- read.table('results.$lang.$method/data/ALL-MATRIX.txt', header=FALSE)
png('results.$lang.$method/data/ALL-MATRIX.png', width=1600, height=800)
myImagePlot(d, title=c('Confusion Matrix for $lang - $date'))\";"

R --vanilla --slave  <<EOF 
source('$EVAL_PATH/MyImagePlot.r')
d <- read.table('results.$lang.$method/data/ALL-MATRIX.txt', header=FALSE)
png('results.$lang.$method/data/ALL-MATRIX.png', width=1600, height=800)
myImagePlot(d, title=c('Confusion Matrix for $lang - $date'))
EOF

# ###########################################################
# # Correspondances:
echo "echo $tags | tr ',' '\n' | cat -n > results.$lang.$method/data/ALL-MATRIX.corresp;"
echo $tags | tr ',' '\n' | cat -n > results.$lang.$method/data/ALL-MATRIX.corresp;

echo "   *  Confusion matrix for $lang                       ---> results.$lang.$method/data/ALL-MATRIX.png";
echo "   *  matrix axes/tags mapping for $lang           ---> results.$lang.$method/data/ALL-MATRIX.corresp";
