RMSE = function(m, o){
  sqrt(mean((m - o)^2, na.rm = T))
}


getfit <- function(yb, useplot = F) {
  C = 1
  y = yb[1]
  B = yb[2]
  # y = 0.03 # Initial storage used 
  # B = 0.075
  
  for (t in 2:131){
    y[t] = y[t-1] * exp(B) / (1 - y[t-1] + (y[t-1] * exp(B)))
  
    C.storage.inf = Cinf * y[t]
    C[t] = C.storage.inf + ((C[t-1] - C.storage.inf) * exp(-alphat)) # with storage
    
  }
  
  sp.year = sparkling %>% group_by(year = year(sampledate)) %>% 
    summarise(cl = mean(cl, na.rm=T))
  
  df = data.frame(year = 1950:2080, C = C, y = y) %>%
    left_join(sp.year) %>% 
    filter(!year %in% 2000:2010)
  rmse.fit = RMSE(df$C,df$cl)
  
  
  if (useplot == T) {
    p = ggplot(df) + geom_line(aes(x = year, y = C), color = 'black', size = 0.9) +
    ylab(bquote('Chloride' ~ (mg~L^-1))) + 
    geom_point(data = sparkling, aes(x = year(sampledate), y = cl), shape = 21, fill = 'lightblue4', size = 0.9) +
    theme_bw(base_size = 8) +
    theme(axis.title.x = element_blank(), plot.title = element_blank())
    
    print(p)
  }
  
  return(rmse.fit)
}

