;$Id: ppmdot_mass.pro,v 1.7 2020/11/09 04:16:53 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=17.6,yoffset=3
  !p.charthick=2 & !p.thick=2 & !x.thick=2 & !y.thick=2
  col0=0
endif else begin
  col0=255
end
;
siz=1.7
!p.charsize=1.7
!x.margin=[7.4,1.3]
!y.margin=[3.2,0.2]
dot='!s!9!A .!n!6!r'
;
!x.range=[0,2.]
!y.range=[0,2.]
;
!p.multi=[0,1,2]
@parameters
default,ivar,428
file='VAR'+str(ivar)+'.sav'
restore,'sav/'+file
;
iy=0
yr=[0,2.1]
!x.title='!6'
!y.title=dot+'!6M!6/'+dot+'!6M!6!d0!n'
ny=n_elements(yy)
plot,xx,4*!pi*xx^2*rrr[*,iy]*uuu[*,iy,0],yr=yr,/nodata
dny=5
ny1=ny/3
ny2=ny/3*2
;
print,'lat limits: ',yy[ny1]/!dtor,yy[ny2]/!dtor
for iy=ny1,ny2,dny do oplot,xx,4*!pi*xx^2*rrr[*,iy]*uuu[*,iy,0],col=col0
for iy=ny2,ny-1,dny do oplot,xx,4*!pi*xx^2*rrr[*,iy]*uuu[*,iy,0],li=2,col=122
for iy=0,ny1,dny do oplot,xx,4*!pi*xx^2*rrr[*,iy]*uuu[*,iy,0],li=1,col=55,thick=6
;
x0=.7 & dx=.3
legend,x0,dx,1.5,0,siz=siz,col=col0,'!630!uo!n < !7h!6 < 60!uo!n'
legend,x0,dx,1.2,2,siz=siz,col=122 ,'!7h!6 > 60!uo!n'
legend,x0,dx,1.8,1,siz=siz,col=55  ,'!7h!6 < 30!uo!n'
oplot,[1,1]*.2,yr
xyouts,.28,.10,siz=siz,'!8r=R!6'
xyouts,1.8,1.84,siz=siz,'!6(a)'
;
iy=0
s=1e4
yr=[1e-3,2e4]
ru2=dot2(uuu)*rrr
 b2=dot2(bbb)
ny=n_elements(yy)
!x.title='!8r!6/!8r!6!dc!n'
!y.title='!6M!8!dr!n!6 / ('+dot+'!6M!6!d0!n !8r!6!dc!n/!8c!6!ds!n)'
plot_io,xx,xx,/nodata,yr=yr
for iy=0,ny-1,dny do begin
  Mr=integr(reform(4*!pi*xx^2*rrr[*,iy]),x=xx,/rev)
  oplot,xx,col=col0,Mr,li=1
  oplot,xx,col=col0,.15+Mr
  print,max(Mr)
endfor
oplot,[1,1]*.2,yr
xyouts,.24,3e-3,siz=siz,'!8r=R!6'
xyouts,1.8,3e3,siz=siz,'!6(b)'
;
!p.multi=0
;
cwd,run
print,"$mv idl.ps ~/tex/jakab/wind/fig/ppmdot_mass_"+run+".ps
END
