;$Id: ppJdot_surf.pro,v 1.1 2020/11/19 18:05:21 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=9.5,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col0=0
endif else begin
  col0=255
end
;
;  Fig.10 of the paper (Nov 2020)
;
siz=1.7
si2=1.5
!p.charsize=1.6
!x.margin=[8.8,1.3]
!y.margin=[3.2,0.2]
dot='!s!9!A .!n!6!r'
;
!x.range=[0,90.] & !x.ticks=6
!y.range=[-1,1]*.1
;
!p.multi=0
@parameters
nuT=8e-5
;
iy=0
!x.title='!7h!6 [degr]'
!y.title='!6stellar surface velocity'
;
ivar1=406 & ivar2=428 & ivar3=2
for ivar=ivar1,ivar2,ivar3 do begin
;
yr_Jdot=[2.4e-7,8e-1]
file='VAR'+str(ivar)+'.sav'
restore,'sav/'+file
;
nx=n_elements(xx)
ny=n_elements(yy)
dy=yy[1]-yy[0]
;
if ivar eq ivar1 then plot,yy/!dtor,uuu[27,*,0]
oplot,yy/!dtor,uuu[27,*,0],col=122
oplot,yy/!dtor,uuu[27,*,2],col=55,li=2
;
endfor
;
xx=8 & dx=10
bar='!20!s!A$!n!r!6'
legend,xx,dx,-.05,0,bar+'!8U!dr!n!6',col=122
legend,xx,dx,-.08,2,bar+'!8U!d!7u!n!6',col=55
;
!p.multi=0
cwd,run
print,"$mv idl.ps ~/tex/jakab/wind/fig/ppJdot_"+run+"_surf.ps
END
