;$Id: ppJdot_single.pro,v 1.7 2020/11/21 21:08:34 brandenb Exp $
if !d.name eq 'PS' then begin
  device,xsize=18,ysize=20,yoffset=3
  !p.charthick=3 & !p.thick=3 & !x.thick=3 & !y.thick=3
  col0=0
endif else begin
  col0=255
end
;
siz=1.5
si2=1.5
!p.charsize=2.7
!x.margin=[7.4,1.3]
!y.margin=[3.2,0.2]
dot='!s!9!A .!n!6!r'
thick1=3
;
!x.range=[0,2.]
!y.range=[0,2.]
;
!p.multi=0
!p.multi=[0,1,3]
@parameters
nuT=8e-5
;
;  panel (a)
;
iy=0
!x.title='!6'
!y.title=dot+'!6J!6/'+dot+'!6J!6!d0!n'
for imodel=0,2 do begin
;
if imodel eq 0 then ivar=0 ;(Model A)
if imodel eq 1 then ivar=204 ;(Model B; used to be loop)
if imodel eq 2 then ivar=71 ;(Model C; used to be loop)
;
if imodel eq 0 then dir='M4096a2_Q001_Om02_cont2'
if imodel eq 1 then dir='M4096b1_Q001_Om1'
if imodel eq 2 then dir='M4096a13_Q01_Om10'
;
if imodel eq 2 then !x.title='!8r!6/!8r!6!dc!n'
;
yr_Jdot=[2.4e-7,1.]
yr_Jdot=[1e-7,10.]
;
if imodel eq 0 then begin
  restore,"../"+dir+'/pppJdot_save.sav'
  JdotDm=JdotDmtt
  JdotKm=JdotKmtt
  JdotMm=JdotMmtt
endif else begin
file='VAR'+str(ivar)+'.sav'
restore,"../"+dir+'/sav/'+file
;
nx=n_elements(xx)
ny=n_elements(yy)
dy=yy[1]-yy[0]
;
;  compute radial Omega gradient, r*dOm/dr = r*d(uphi/r)/dr
;
dom=fltarr(nx,ny)
for iy=0,ny-1 do dom[*,iy]=xx*deriv(xx,reform(uuu[*,iy,2]/xx))
;
JdotD=-4*!pi*(xx^3#sin(yy))*rrr*nuT       *dom[*,*  ]
JdotK=+4*!pi*(xx^3#sin(yy))*rrr*uuu[*,*,0]*uuu[*,*,2]
JdotM=-4*!pi*(xx^3#sin(yy))    *bbb[*,*,0]*bbb[*,*,2]
;
;  integrate over all latitudes
;
JdotDm=total(JdotD,2)*dy
JdotKm=total(JdotK,2)*dy
JdotMm=total(JdotM,2)*dy
endelse
;
plot_io,xx,abs(JdotKm+JdotMm+JdotDm),yr=yr_Jdot,l=1,/nodata
oplot,xx,JdotDm,thick=thick1
oplot,xx,JdotKm,thick=thick1,col=55
oplot,xx,JdotMm,thick=thick1,col=122
;oplot,xx,JdotDm+JdotKm+JdotMm,thick=thick1,li=1
;
oplot,xx,-JdotDm,thick=thick1,li=2
oplot,xx,-JdotKm,thick=thick1,li=2,col=55
oplot,xx,-JdotMm,thick=thick1,li=2,col=122
;
;  labels
;
if imodel eq 0 then xyouts,1.82,1.,siz=siz,'!6(a)'
if imodel eq 1 then xyouts,1.82,1.,siz=siz,'!6(b)'
if imodel eq 2 then begin
  xyouts,1.82,1.,siz=siz,'!6(c)'
  xyouts,1.00,3e-2,siz=si2,dot+'!8J!6!dK!n',col=55
  xyouts,0.60,4e-4,siz=si2,dot+'!8J!7!dm!6!n'
  xyouts,0.62,2e-6,siz=si2,dot+'!8J!6!dM!n',col=122
endif
;
;  mark surface of star
;
oplot,[1,1]*.2,yr_Jdot,li=3
endfor
!p.multi=0
;
print,"$mv idl.ps ~/tex/jakab/wind/fig/ppJdot_single.ps
END
